/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public class GroovyTrivialConditionalInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        return "Redundant conditional expression";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        GrConditionalExpression exp = (GrConditionalExpression)args[0];
        return "'" + exp.getText() + "' can be simplified to '" + GroovyTrivialConditionalInspection.calculateReplacementExpression(exp) + "'  #loc";
    }

    private static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new TrivialConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression exp) {
            super.visitConditionalExpression(exp);
            GrExpression condition = exp.getCondition();
            PsiType type2 = condition.getType();
            if (type2 == null || !PsiType.BOOLEAN.isAssignableFrom(type2)) {
                return;
            }
            if (ErrorUtil.containsError(exp)) {
                return;
            }
            GrExpression thenExpression = exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression) || GroovyTrivialConditionalInspection.isTrue(thenExpression) && GroovyTrivialConditionalInspection.isFalse(elseExpression)) {
                this.registerError(exp);
            }
        }
    }

    private static class TrivialConditionalFix
    extends GroovyFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor2.getPsiElement();
            String newExpression = GroovyTrivialConditionalInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression(expression, newExpression);
        }
    }
}

