/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public class InvalidWriteAccessSearcher {
    @Nullable
    public static List<ReadWriteVariableInstruction> findInvalidWriteAccess(@NotNull Instruction[] flow, @NotNull Set<? extends GrVariable> variables, @NotNull Set<? extends GrVariable> alreadyInitialized) {
        DFAEngine<MyData> engine = new DFAEngine<MyData>(flow, new MyDFAInstance(), new MySemilattice());
        List<MyData> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return null;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Set descriptors = variables.stream().map(VariableDescriptorFactory::createDescriptor).collect(Collectors.toSet());
        Set initializedDescriptors = alreadyInitialized.stream().map(VariableDescriptorFactory::createDescriptor).collect(Collectors.toSet());
        for (int i = 0; i < flow.length; ++i) {
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            MyData initialized = dfaResult.get(i);
            VariableDescriptor descriptor2 = ((ReadWriteVariableInstruction)instruction).getDescriptor();
            if (!descriptors.contains(descriptor2)) continue;
            if (initializedDescriptors.contains(descriptor2)) {
                if (!initialized.isInitialized(descriptor2)) continue;
                result2.add((ReadWriteVariableInstruction)instruction);
                continue;
            }
            if (!initialized.isOverInitialized(descriptor2)) continue;
            result2.add((ReadWriteVariableInstruction)instruction);
        }
        return result2;
    }

    private static class MyData {
        private final Set<VariableDescriptor> myInitialized = ContainerUtil.newHashSet();
        private final Set<VariableDescriptor> myOverInitialized = ContainerUtil.newHashSet();

        MyData(List<? extends MyData> ins) {
            for (MyData myData : ins) {
                this.myInitialized.addAll(myData.myInitialized);
                this.myOverInitialized.addAll(myData.myOverInitialized);
            }
        }

        MyData() {
        }

        public void add(VariableDescriptor var) {
            if (!this.myInitialized.add(var)) {
                this.myOverInitialized.add(var);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof MyData && this.myInitialized.equals(((MyData)obj).myInitialized) && this.myOverInitialized.equals(((MyData)obj).myOverInitialized);
        }

        public boolean isOverInitialized(VariableDescriptor var) {
            return this.myOverInitialized.contains(var);
        }

        public boolean isInitialized(VariableDescriptor var) {
            return this.myInitialized.contains(var);
        }
    }

    private static class MySemilattice
    implements Semilattice<MyData> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public MyData join(@NotNull List<? extends MyData> ins) {
            return new MyData(ins);
        }

        @Override
        public boolean eq(@NotNull MyData e1, @NotNull MyData e2) {
            return e1.equals(e2);
        }
    }

    private static class MyDFAInstance
    implements DfaInstance<MyData> {
        private MyDFAInstance() {
        }

        @Override
        public void fun(@NotNull MyData e, @NotNull Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite()) {
                e.add(((ReadWriteVariableInstruction)instruction).getDescriptor());
            }
        }

        @Override
        @NotNull
        public MyData initial() {
            return new MyData();
        }
    }
}

