/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptyTryBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Empty 'try' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
            super.visitTryStatement(tryCatchStatement);
            GrOpenBlock body = tryCatchStatement.getTryBlock();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(tryCatchStatement.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements = body.getStatements();
            return statements.length == 0;
        }
    }
}

