/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;

public class GroovyReturnFromFinallyBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "'return' inside 'finally' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            super.visitReturnStatement(returnStatement);
            if (!ControlFlowUtils.isInFinallyBlock(returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }
    }
}

