/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NestingDepthVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyNestedMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyOverlyNestedMethodInspectionBase() {
        super(5);
    }

    @NotNull
    public String getDisplayName() {
        return "Overly nested method";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is overly nested ( nesting depth =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            super.visitMethod(grMethod);
            int limit = GroovyOverlyNestedMethodInspectionBase.this.getLimit();
            NestingDepthVisitor visitor2 = new NestingDepthVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor2);
            int nestingDepth = visitor2.getMaximumDepth();
            if (nestingDepth <= limit) {
                return;
            }
            this.registerMethodError(grMethod, nestingDepth, limit);
        }
    }
}

