/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

class NestingDepthVisitor
extends GroovyRecursiveElementVisitor {
    private int m_maximumDepth = 0;
    private int m_currentDepth = 0;

    NestingDepthVisitor() {
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement statement) {
        boolean isAlreadyCounted;
        PsiElement parent2 = statement.getParent();
        boolean bl = isAlreadyCounted = parent2 instanceof GrWhileStatement || parent2 instanceof GrForStatement || parent2 instanceof GrIfStatement;
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitBlockStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement statement) {
        this.enterScope();
        super.visitForStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement statement) {
        boolean isAlreadyCounted = false;
        if (statement.getParent() instanceof GrIfStatement) {
            GrIfStatement parent2 = (GrIfStatement)statement.getParent();
            assert (parent2 != null);
            GrStatement elseBranch = parent2.getElseBranch();
            if (statement.equals(elseBranch)) {
                isAlreadyCounted = true;
            }
        }
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitIfStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement statement) {
        this.enterScope();
        super.visitTryStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement statement) {
        this.enterScope();
        super.visitSwitchStatement(statement);
        this.exitScope();
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement statement) {
        this.enterScope();
        super.visitWhileStatement(statement);
        this.exitScope();
    }

    private void enterScope() {
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
    }

    private void exitScope() {
        --this.m_currentDepth;
    }

    public int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

