/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.naming.NewClassNamingConventionInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class NewGroovyClassNamingConventionInspection
extends AbstractNamingConventionInspection<PsiClass> {
    public NewGroovyClassNamingConventionInspection() {
        super(NewGroovyClassNamingConventionInspection.wrapClassExtensions(), "GroovyClassNamingConvention");
    }

    private static List<NamingConvention<PsiClass>> wrapClassExtensions() {
        return ContainerUtil.map((Object[])NewClassNamingConventionInspection.EP_NAME.getExtensions(), ex -> new NamingConvention<PsiClass>(){

            public boolean isApplicable(PsiClass member) {
                return ex.isApplicable((PsiNameIdentifierOwner)member);
            }

            public String getElementDescription() {
                return ex.getElementDescription();
            }

            public String getShortName() {
                String shortName = ex.getShortName();
                if (shortName.startsWith("JUnit")) {
                    return shortName;
                }
                return "Groovy" + (shortName.startsWith("Enum") ? "EnumerationNamingConvention" : shortName);
            }

            public NamingConventionBean createDefaultBean() {
                return ex.createDefaultBean();
            }
        });
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof GrTypeDefinition) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        return;
                    }
                    NewGroovyClassNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)aClass, name, holder);
                }
            }
        };
    }

    protected LocalQuickFix createRenameFix() {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }
}

