/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;

public class RenameFix
extends GroovyFix
implements RefactoringQuickFix {
    private final String targetName;

    public RenameFix() {
        this.targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.targetName == null) {
            return "Rename";
        }
        return "Rename to " + this.targetName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Rename";
    }

    @Override
    public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (this.targetName == null) {
            this.doFix(element);
        } else {
            PsiElement elementToRename = element.getParent();
            RefactoringFactory.getInstance((Project)project).createRename(elementToRename, this.targetName).run();
        }
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        return RefactoringActionHandlerFactory.getInstance().createRenameHandler();
    }
}

