/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovySynchronizationOnNonFinalFieldInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Synchronization on non-final field";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Synchronization on non-final field '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (!(lock instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lock).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("final")) {
                return;
            }
            this.registerError(lock);
        }
    }
}

