/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovySynchronizationOnThisInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Synchronization on 'this'";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Synchronization on '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (lock == null || !(lock instanceof GrReferenceExpression) || !PsiUtil.isThisReference(lock)) {
                return;
            }
            this.registerError(lock);
        }
    }
}

