/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GroovyStaticTypeCheckVisitor
extends GroovyTypeCheckVisitor {
    private AnnotationHolder myHolder;

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer != null) {
            PsiType[] types = (PsiType[])Arrays.stream(expression.getLValue().getExpressions()).map(it -> it.getType()).toArray(PsiType[]::new);
            this.checkTupleAssignment(initializer, types);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GrExpression initializer;
        if (variableDeclaration.isTuple() && (initializer = variableDeclaration.getTupleInitializer()) != null) {
            PsiType[] types = (PsiType[])Arrays.stream(variableDeclaration.getVariables()).map(it -> it.getType()).toArray(PsiType[]::new);
            this.checkTupleAssignment(initializer, types);
        }
        super.visitVariableDeclaration(variableDeclaration);
    }

    void checkTupleAssignment(@NotNull GrExpression initializer, @NotNull PsiType[] types) {
        if (initializer instanceof GrListOrMap && !((GrListOrMap)initializer).isMap()) {
            GrListOrMap initializerList = (GrListOrMap)initializer;
            GrExpression[] expressions = initializerList.getInitializers();
            if (types.length > expressions.length) {
                this.registerError((PsiElement)initializer, GroovyBundle.message("incorrect.number.of.values", types.length, expressions.length), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR);
            }
            return;
        }
        this.registerError((PsiElement)initializer, GroovyBundle.message("multiple.assignments.without.list.expr", new Object[0]), new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createMultipleAssignmentFix(types.length)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    protected void registerError(final @NotNull PsiElement location, final @NotNull String description, final @Nullable LocalQuickFix[] fixes, final ProblemHighlightType highlightType) {
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        ArrayList intentions = ContainerUtil.newArrayList();
        if (fixes != null) {
            for (final LocalQuickFix fix : fixes) {
                intentions.add(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        return fix.getName();
                    }

                    @NotNull
                    public String getFamilyName() {
                        return fix.getFamilyName();
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        return true;
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                        InspectionManager manager = InspectionManager.getInstance((Project)project);
                        ProblemDescriptor descriptor2 = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
                        fix.applyFix(project, (CommonProblemDescriptor)descriptor2);
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }
                });
            }
        }
        this.registerError(location, description, intentions.toArray(IntentionAction.EMPTY_ARRAY), highlightType);
    }

    protected void registerError(@NotNull PsiElement location, @NotNull String description, @Nullable IntentionAction[] fixes, ProblemHighlightType highlightType) {
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(location, description);
        if (fixes == null) {
            return;
        }
        for (IntentionAction intention : fixes) {
            annotation.registerFix(intention);
        }
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
    }

    public void accept(@NotNull GroovyPsiElement element, @NotNull AnnotationHolder holder) {
        this.myHolder = holder;
        try {
            element.accept(this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitSpreadArgument(@NotNull GrSpreadArgument spreadArgument) {
        this.registerError((PsiElement)spreadArgument, GroovyBundle.message("spread.operator.is.not.available", new Object[0]), GroovyStaticTypeCheckVisitor.buildSpreadArgumentFix(spreadArgument), ProblemHighlightType.GENERIC_ERROR);
    }

    private static LocalQuickFix[] buildSpreadArgumentFix(GrSpreadArgument spreadArgument) {
        GrCallExpression parent2 = (GrCallExpression)PsiTreeUtil.getParentOfType((PsiElement)spreadArgument, GrCallExpression.class);
        if (parent2 == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiMethod resolveMethod = parent2.resolveMethod();
        if (resolveMethod == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createSpreadArgumentFix(resolveMethod.getParameters().length)};
    }
}

