/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.DelegatingCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrBinaryExprInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrConstructorInvocationInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrEnumConstantInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrIndexPropertyInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrListOrMapInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrMethodCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrNewExpressionInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GroovyAssignabilityCheckInspection;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.ImplKt;
import org.jetbrains.plugins.groovy.codeInspection.type.PrecisionUtil;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;

public class GroovyTypeCheckVisitor
extends BaseInspectionVisitor {
    private static final Logger LOG = Logger.getInstance(GroovyAssignabilityCheckInspection.class);
    private final HighlightSink myHighlightSink = new HighlightSink(){

        @Override
        public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, LocalQuickFix ... fixes) {
            GroovyTypeCheckVisitor.this.registerError(highlightElement, message, fixes, highlightType);
        }
    };

    private boolean checkCallApplicability(@Nullable PsiType type2, boolean checkUnknownArgs, @NotNull CallInfo<? extends GroovyPsiElement> info) {
        PsiType[] argumentTypes = info.getArgumentTypes();
        GrExpression invoked = info.getInvokedExpression();
        if (invoked == null) {
            return true;
        }
        if (type2 instanceof GrClosureType) {
            if (argumentTypes == null) {
                return true;
            }
            Applicability result2 = PsiUtil.isApplicableConcrete(argumentTypes, (GrClosureType)type2, info.getCall());
            switch (result2) {
                case inapplicable: {
                    this.registerCannotApplyError(invoked.getText(), info);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }
        if (type2 != null) {
            GroovyResolveResult[] calls;
            for (GroovyResolveResult result3 : calls = ResolveUtil.getMethodCandidates(type2, "call", (PsiElement)invoked, argumentTypes)) {
                PsiElement resolved = result3.getElement();
                if (!(resolved instanceof PsiMethod && !result3.isInvokedOnProperty() ? !this.checkMethodApplicability(result3, checkUnknownArgs, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), checkUnknownArgs && calls.length == 1, info))) continue;
                return false;
            }
            if (calls.length == 0 && !(invoked instanceof GrString)) {
                this.registerCannotApplyError(invoked.getText(), info);
            }
            return true;
        }
        return true;
    }

    private boolean checkCannotInferArgumentTypes(@NotNull CallInfo info) {
        if (info.getArgumentTypes() != null) {
            return true;
        }
        this.highlightUnknownArgs(info);
        return false;
    }

    private <T extends GroovyPsiElement> boolean checkConstructorApplicability(@NotNull GroovyResolveResult constructorResolveResult, @NotNull CallInfo<T> info, boolean checkUnknownArgs) {
        PsiType[] newTypes;
        GrExpression[] exprArgs;
        PsiElement element = constructorResolveResult.getElement();
        LOG.assertTrue(element instanceof PsiMethod && ((PsiMethod)element).isConstructor(), (Object)element);
        PsiMethod constructor = (PsiMethod)element;
        GrArgumentList argList = info.getArgumentList();
        if (argList != null && (exprArgs = argList.getExpressionArguments()).length == 0 && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
            return true;
        }
        PsiType[] types = info.getArgumentTypes();
        PsiClass containingClass = constructor.getContainingClass();
        if (types != null && containingClass != null && (newTypes = GrInnerClassConstructorUtil.addEnclosingArgIfNeeded(types, info.getCall(), containingClass)).length != types.length) {
            return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, new DelegatingCallInfo<T>(info){

                @Override
                @NotNull
                public PsiType[] getArgumentTypes() {
                    return newTypes;
                }
            });
        }
        return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, info);
    }

    private void processConstructorCall(@NotNull ConstructorCallInfo<?> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        GroovyResolveResult[] results = info.multiResolve();
        boolean checkUnknowkArgs = results.length == 1;
        for (GroovyResolveResult result2 : results) {
            PsiElement resolved = result2.getElement();
            if (!(resolved instanceof PsiMethod) || this.checkConstructorApplicability(result2, info, checkUnknowkArgs)) continue;
            return;
        }
        if (results.length > 1) {
            this.registerError(info.getElementToHighlight(), GroovyBundle.message("constructor.call.is.ambiguous", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
        }
        this.checkNamedArgumentsType(info);
    }

    private boolean checkForImplicitEnumAssigning(@Nullable PsiType expectedType, @NotNull GrExpression expression, @NotNull GroovyPsiElement elementToHighlight) {
        if (!(expectedType instanceof PsiClassType)) {
            return false;
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(elementToHighlight, "1.8")) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)expectedType).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return false;
        }
        PsiType type2 = expression.getType();
        if (type2 == null) {
            return false;
        }
        if (!type2.equalsToText("groovy.lang.GString") && !type2.equalsToText("java.lang.String")) {
            return false;
        }
        Object result2 = GroovyConstantExpressionEvaluator.evaluate(expression);
        if (!(result2 instanceof String)) {
            this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
        } else {
            PsiField field = resolved.findFieldByName((String)result2, true);
            if (!(field instanceof PsiEnumConstant)) {
                this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result2, expectedType.getPresentableText())});
            }
        }
        return true;
    }

    private void checkIndexProperty(@NotNull CallInfo<GrIndexProperty> info) {
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        PsiType[] types = info.getArgumentTypes();
        if (types == null) {
            return;
        }
        GroovyResolveResult[] results = info.multiResolve();
        GroovyResolveResult resolveResult2 = info.advancedResolve();
        if (resolveResult2.getElement() != null) {
            PsiElement resolved = resolveResult2.getElement();
            if (resolved instanceof PsiMethod && !resolveResult2.isInvokedOnProperty()) {
                this.checkMethodApplicability(resolveResult2, true, info);
            } else if (resolved instanceof GrField) {
                this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), true, info);
            } else if (resolved instanceof PsiField) {
                this.checkCallApplicability(((PsiField)resolved).getType(), true, info);
            }
        } else if (results.length > 0) {
            for (GroovyResolveResult result2 : results) {
                PsiElement resolved = result2.getElement();
                if (!(resolved instanceof PsiMethod && !result2.isInvokedOnProperty() ? !this.checkMethodApplicability(result2, false, info) : (resolved instanceof GrField ? !this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), false, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), false, info)))) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        } else {
            String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(types);
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.find.operator.overload.method", typesString)});
        }
    }

    private <T extends GroovyPsiElement> boolean checkMethodApplicability(@NotNull GroovyResolveResult methodResolveResult, boolean checkUnknownArgs, @NotNull CallInfo<T> info) {
        PsiElement element = methodResolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return true;
        }
        if (element instanceof GrBuilderMethod) {
            return true;
        }
        PsiMethod method = (PsiMethod)element;
        Applicability applicable = GroovyTypeCheckVisitor.calcApplicability(method, methodResolveResult.getSubstitutor(), info);
        switch (applicable) {
            case inapplicable: {
                this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                return false;
            }
            case canBeApplicable: {
                if (checkUnknownArgs) {
                    this.highlightUnknownArgs(info);
                }
                return !checkUnknownArgs;
            }
        }
        return true;
    }

    private static <T extends GroovyPsiElement> Applicability calcApplicability(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull CallInfo<T> info) {
        PsiType type2;
        GrExpression qualifierExpression;
        if ("call".equals(method.getName()) && info.getInvokedExpression() instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)info.getInvokedExpression()).getQualifierExpression()) != null && (type2 = qualifierExpression.getType()) instanceof GrClosureType) {
            return PsiUtil.isApplicableConcrete(info.getArgumentTypes(), (GrClosureType)type2, info.getInvokedExpression());
        }
        return PsiUtil.isApplicableConcrete(info.getArgumentTypes(), method, substitutor, info.getCall(), false);
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        super.visitMethodCall(call);
        if (GroovyExpressionUtil.isFake(call)) {
            return;
        }
        this.checkMethodCall(new GrMethodCallInfo(call));
    }

    private void checkMethodCall(@NotNull CallInfo<? extends GrMethodCall> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (info.getInvokedExpression() instanceof GrReferenceExpression) {
            GrExpression qualifier;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)info.getInvokedExpression();
            GroovyResolveResult resolveResult2 = info.advancedResolve();
            GroovyResolveResult[] results = info.multiResolve();
            PsiElement resolved = resolveResult2.getElement();
            if (resolved == null && (qualifier = referenceExpression.getQualifierExpression()) == null && GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            if (resolved != null) {
                if (resolved instanceof PsiMethod && !resolveResult2.isInvokedOnProperty()) {
                    GrMethodCall call = info.getCall();
                    GroovyMethodCallReference reference = call.getImplicitCallReference();
                    if (reference != null) {
                        this.checkCallApplicability(reference.getReceiver(), true, info);
                    } else {
                        this.checkMethodApplicability(resolveResult2, true, info);
                    }
                } else {
                    this.checkCallApplicability(referenceExpression.getType(), true, info);
                }
            } else if (results.length > 0) {
                Object[] argumentTypes = info.getArgumentTypes();
                boolean checkUnknownArgs = argumentTypes == null || ContainerUtil.or((Object[])argumentTypes, Objects::isNull);
                for (GroovyResolveResult result2 : results) {
                    PsiElement current = result2.getElement();
                    if (!(current instanceof PsiMethod && !result2.isInvokedOnProperty() ? !this.checkMethodApplicability(result2, checkUnknownArgs, info) : !this.checkCallApplicability(referenceExpression.getType(), checkUnknownArgs, info))) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
            }
        } else if (info.getInvokedExpression() != null) {
            PsiType type2 = info.getInvokedExpression().getType();
            this.checkCallApplicability(type2, true, info);
        }
        this.checkNamedArgumentsType(info);
    }

    private void checkNamedArgumentsType(@NotNull CallInfo<?> info) {
        Object rawCall = info.getCall();
        if (!(rawCall instanceof GrCall)) {
            return;
        }
        GrCall call = (GrCall)rawCall;
        GrNamedArgument[] namedArguments = PsiUtil.getFirstMapNamedArguments(call);
        if (namedArguments.length == 0) {
            return;
        }
        Map<String, NamedArgumentDescriptor> map2 = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
        if (map2 == null) {
            return;
        }
        this.checkNamedArguments(call, namedArguments, map2);
    }

    private void checkNamedArguments(GroovyPsiElement context, GrNamedArgument[] namedArguments, Map<String, NamedArgumentDescriptor> map2) {
        for (GrNamedArgument namedArgument : namedArguments) {
            PsiType expressionType;
            GrExpression namedArgumentExpression;
            String labelName = namedArgument.getLabelName();
            NamedArgumentDescriptor descriptor2 = map2.get(labelName);
            if (descriptor2 == null || (namedArgumentExpression = namedArgument.getExpression()) == null || GroovyTypeCheckVisitorHelper.getTupleInitializer(namedArgumentExpression) != null || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), context.getManager(), context.getResolveScope())) == null || descriptor2.checkType(expressionType, context)) continue;
            this.registerError((PsiElement)namedArgumentExpression, ProblemHighlightType.GENERIC_ERROR, new Object[]{"Type of argument '" + labelName + "' can not be '" + expressionType.getPresentableText() + "'"});
        }
    }

    private void checkOperator(@NotNull CallInfo<? extends GrBinaryExpression> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getCall())) {
            return;
        }
        GroovyResolveResult[] results = info.multiResolve();
        GroovyResolveResult resolveResult2 = info.advancedResolve();
        if (GroovyTypeCheckVisitorHelper.isOperatorWithSimpleTypes(info.getCall(), resolveResult2)) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        if (resolveResult2.getElement() != null) {
            this.checkMethodApplicability(resolveResult2, true, info);
        } else if (results.length > 0) {
            for (GroovyResolveResult result2 : results) {
                if (this.checkMethodApplicability(result2, false, info)) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        }
    }

    private void highlightInapplicableMethodUsage(@NotNull GroovyResolveResult methodResolveResult, @NotNull CallInfo info, @NotNull PsiMethod method) {
        String message;
        PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
        PsiType[] argumentTypes = info.getArgumentTypes();
        if (containingClass == null) {
            this.registerCannotApplyError(method.getName(), info);
            return;
        }
        if (method instanceof DefaultConstructor) {
            message = GroovyBundle.message("cannot.apply.default.constructor", method.getName());
        } else {
            String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(argumentTypes);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            PsiClassType containingType = factory.createType(containingClass, methodResolveResult.getSubstitutor());
            String canonicalText = containingType.getInternalCanonicalText();
            message = method.isConstructor() ? GroovyBundle.message("cannot.apply.constructor", method.getName(), canonicalText, typesString) : GroovyBundle.message("cannot.apply.method1", method.getName(), canonicalText, typesString);
        }
        this.registerError(info.getElementToHighlight(), message, GroovyTypeCheckVisitorHelper.genCastFixes(GrClosureSignatureUtil.createSignature(methodResolveResult), argumentTypes, info.getArgumentList()), ProblemHighlightType.GENERIC_ERROR);
    }

    private void highlightUnknownArgs(@NotNull CallInfo info) {
        this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.infer.argument.types", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.WEAK_WARNING);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull PsiElement context) {
        this.checkPossibleLooseOfPrecision(expectedType, expression, toHighlight);
        this.processAssignment(expectedType, expression, toHighlight, "cannot.assign", context, GrTypeConverter.ApplicableTo.ASSIGNMENT);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        GrListOrMap initializer = GroovyTypeCheckVisitorHelper.getTupleInitializer(expression);
        if (initializer != null) {
            this.processConstructorCall(new GrListOrMapInfo(initializer));
            return;
        }
        if (PsiUtil.isRawClassMemberAccess(expression)) {
            return;
        }
        if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
            return;
        }
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(expectedType, actualType, context, position);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ArrayList fixes = ContainerUtil.newArrayList();
        fixes.add(new GrCastFix(expectedType, expression));
        String varName = GroovyTypeCheckVisitorHelper.getLValueVarName(toHighlight);
        if (varName != null) {
            fixes.add(new GrChangeVariableType(actualType, varName));
        }
        String message = GroovyBundle.message(messageKey, actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError(toHighlight, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private void processAssignment(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull GroovyPsiElement context, @NotNull PsiElement elementToHighlight) {
        if (rType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(lType, rType, context, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        this.processResult(result2, elementToHighlight, "cannot.assign", lType, rType, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void processAssignmentWithinMultipleAssignment(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (targetType == null || actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssignWithinMultipleAssignment(targetType, actualType);
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", actualType.getPresentableText(), targetType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer == null) {
            return;
        }
        GrTuple tupleExpression = expression.getLValue();
        GrReferenceExpression[] lValues = tupleExpression.getExpressions();
        if (initializer instanceof GrListOrMap) {
            GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
            for (int i = 0; i < lValues.length; ++i) {
                GrReferenceExpression lValue = lValues[i];
                if (initializers.length > i) {
                    GrExpression rValue = initializers[i];
                    this.processAssignmentWithinMultipleAssignment(lValue.getType(), rValue.getType(), expression, rValue);
                    continue;
                }
                break;
            }
        } else {
            PsiType type2 = initializer.getType();
            PsiType rType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
            for (GrReferenceExpression lValue : lValues) {
                PsiType lType = lValue.getNominalType();
                if (PsiImplUtil.isSpreadAssignment(lValue)) {
                    PsiType argType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
                    if (argType != null && rType != null) {
                        this.processAssignment(argType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
                    }
                    return;
                }
                if (lValue instanceof GrReferenceExpression && lValue.resolve() instanceof GrReferenceExpression) {
                    return;
                }
                if (lType == null || rType == null) continue;
                this.processAssignment(lType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
            }
        }
    }

    private void processResult(@NotNull ConversionResult result2, @NotNull PsiElement elementToHighlight, @NotNull @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, @NotNull PsiType lType, @NotNull PsiType rType, @NotNull LocalQuickFix[] fixes) {
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message(messageKey, rType.getPresentableText(), lType.getPresentableText()), fixes, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processReturnValue(@NotNull GrExpression expression, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (GroovyTypeCheckVisitorHelper.getTupleInitializer(expression) != null) {
            return;
        }
        PsiType returnType2 = PsiImplUtil.inferReturnType(expression);
        if (returnType2 == null || PsiType.VOID.equals((Object)returnType2)) {
            return;
        }
        this.processAssignment(returnType2, expression, elementToHighlight, "cannot.return.type", context, GrTypeConverter.ApplicableTo.RETURN_VALUE);
    }

    private void registerCannotApplyError(@NotNull String invokedText, @NotNull CallInfo info) {
        if (info.getArgumentTypes() == null) {
            return;
        }
        String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(info.getArgumentTypes());
        this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString)});
    }

    @Override
    protected void registerError(@NotNull PsiElement location, @NotNull String description, @Nullable LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (PsiUtil.isCompileStatic(location)) {
            if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
                super.registerError(location, description, fixes, highlightType);
            }
        } else if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
            super.registerError(location, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        } else {
            super.registerError(location, description, fixes, highlightType);
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        super.visitReturnStatement(returnStatement);
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            this.processReturnValue(value, returnStatement, returnStatement.getReturnWord());
        }
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        super.visitThrowStatement(throwStatement);
        GrExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiElement throwWord = throwStatement.getFirstChild();
        this.processAssignment((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord, throwWord);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        super.visitExpression(expression);
        if (ControlFlowUtils.isImplicitReturnStatement(expression)) {
            this.processReturnValue(expression, expression, expression);
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        super.visitNewExpression(newExpression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression) || GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression.getArgumentList())) {
            return;
        }
        GroovyCallReference reference = newExpression.getConstructorReference();
        if (reference == null) {
            return;
        }
        GrNewExpressionInfo info = new GrNewExpressionInfo(newExpression);
        if (ImplKt.processConstructor(reference, newExpression.getArgumentList(), info.getElementToHighlight(), this.myHighlightSink)) {
            return;
        }
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant) || GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant.getArgumentList())) {
            return;
        }
        GrEnumConstantInfo info = new GrEnumConstantInfo(enumConstant);
        GroovyCallReference reference = enumConstant.getConstructorReference();
        if (ImplKt.processConstructor(reference, enumConstant.getArgumentList(), info.getElementToHighlight(), this.myHighlightSink)) {
            return;
        }
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        super.visitConstructorInvocation(invocation);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(invocation) || GroovyTypeCheckVisitorHelper.hasErrorElements(invocation.getArgumentList())) {
            return;
        }
        GrConstructorInvocationInfo info = new GrConstructorInvocationInfo(invocation);
        GroovyCallReference reference = invocation.getConstructorReference();
        if (ImplKt.processConstructor(reference, invocation.getArgumentList(), info.getElementToHighlight(), this.myHighlightSink)) {
            return;
        }
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
        PsiType targetType;
        super.visitAssignmentExpression(assignment);
        if (assignment.isOperatorAssignment()) {
            return;
        }
        GrExpression lValue = assignment.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            return;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return;
        }
        if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
            return;
        }
        PsiType lValueNominalType = lValue.getNominalType();
        PsiType psiType = targetType = PsiImplUtil.isSpreadAssignment(lValue) ? com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lValueNominalType, (boolean)false) : lValueNominalType;
        if (targetType == null) {
            return;
        }
        this.processAssignment(targetType, rValue, (PsiElement)lValue, (PsiElement)assignment);
    }

    void checkPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight) {
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        if (!PrecisionUtil.INSTANCE.isPossibleLooseOfPrecision(targetType, actualType, expression)) {
            return;
        }
        this.registerError(toHighlight, GroovyBundle.message("loss.of.precision", actualType.getPresentableText(), targetType.getPresentableText()), new LocalQuickFix[]{new GrCastFix(targetType, expression, false)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression binary) {
        super.visitBinaryExpression(binary);
        if (GroovyExpressionUtil.isFake(binary)) {
            return;
        }
        this.checkOperator(new GrBinaryExprInfo(binary));
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression expression) {
        super.visitCastExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType actualType = operand.getType();
        if (actualType == null) {
            return;
        }
        if (expression.getCastTypeElement() == null) {
            return;
        }
        PsiType expectedType = expression.getCastTypeElement().getType();
        ConversionResult result2 = TypesUtil.canCast(expectedType, actualType, expression);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ProblemHighlightType highlightType = result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        String message = GroovyBundle.message("cannot.cast", actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError((PsiElement)expression, highlightType, new Object[]{message});
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        super.visitIndexProperty(expression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isClassLiteral(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isSimpleArrayAccess(expression)) {
            return;
        }
        if (expression.getRValueReference() != null) {
            this.checkIndexProperty(new GrIndexPropertyInfo(expression, true));
        }
        if (expression.getLValueReference() != null) {
            this.checkIndexProperty(new GrIndexPropertyInfo(expression, false));
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        super.visitMethod(method);
        PsiTypeParameter[] parameters = method.getTypeParameters();
        HashMap map2 = ContainerUtil.newHashMap();
        for (PsiTypeParameter parameter : parameters) {
            PsiClassType[] types = parameter.getSuperTypes();
            PsiType bound = PsiIntersectionType.createIntersection((PsiType[])types);
            PsiWildcardType wildcardType = PsiWildcardType.createExtends((PsiManager)method.getManager(), (PsiType)bound);
            map2.put(parameter, wildcardType);
        }
        PsiSubstitutor substitutor = PsiSubstitutorImpl.createSubstitutor((Map)map2);
        for (GrParameter parameter : method.getParameterList().getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null) continue;
            PsiType targetType = parameter.getType();
            this.processAssignment(substitutor.substitute(targetType), initializer, parameter.getNameIdentifierGroovy(), (PsiElement)parameter);
        }
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        super.visitParameterList(parameterList);
        PsiElement parent2 = parameterList.getParent();
        if (!(parent2 instanceof GrFunctionalExpression)) {
            return;
        }
        Object[] parameters = parameterList.getParameters();
        if (parameters.length > 0) {
            List<PsiType[]> signatures = ClosureParamsEnhancer.findFittingSignatures((GrFunctionalExpression)parent2);
            List paramTypes = ContainerUtil.map((Object[])parameters, parameter -> parameter.getType());
            if (signatures.size() > 1) {
                PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures, types -> {
                    for (int i = 0; i < ((PsiType[])types).length; ++i) {
                        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)paramTypes.get(i), types[i], parameterList)) continue;
                        return false;
                    }
                    return true;
                });
                if (fittingSignature == null) {
                    this.registerError((PsiElement)parameterList, GroovyInspectionBundle.message("no.applicable.signature.found", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (signatures.size() == 1) {
                PsiType[] types2 = signatures.get(0);
                for (int i = 0; i < types2.length; ++i) {
                    GrTypeElement typeElement = parameters[i].getTypeElementGroovy();
                    if (typeElement == null) continue;
                    PsiType expected = types2[i];
                    PsiType actual = (PsiType)paramTypes.get(i);
                    if (TypesUtil.isAssignableByMethodCallConversion(actual, expected, parameterList)) continue;
                    this.registerError((PsiElement)typeElement, GroovyInspectionBundle.message("expected.type.0", expected.getCanonicalText(false), actual.getCanonicalText(false)), null, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        super.visitForInClause(forInClause);
        GrVariable variable = forInClause.getDeclaredVariable();
        GrExpression iterated = forInClause.getIteratedExpression();
        if (variable == null || iterated == null) {
            return;
        }
        PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forInClause);
        if (iteratedType == null) {
            return;
        }
        PsiType targetType = variable.getType();
        ConversionResult result2 = TypesUtil.canAssign(targetType, iteratedType, forInClause, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        LocalQuickFix[] fixes = new LocalQuickFix[]{new GrCastFix((PsiType)TypesUtil.createListType(iterated, targetType), iterated)};
        this.processResult(result2, variable, "cannot.assign", targetType, iteratedType, fixes);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        GrExpression initializer;
        super.visitVariable(variable);
        PsiType varType = variable.getType();
        PsiElement parent2 = variable.getParent();
        if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod || parent2 instanceof GrForInClause) {
            return;
        }
        if (parent2 instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent2).isTuple()) {
            GrVariableDeclaration tuple = (GrVariableDeclaration)parent2;
            GrExpression initializer2 = tuple.getTupleInitializer();
            if (initializer2 == null) {
                return;
            }
            if (!(initializer2 instanceof GrListOrMap) && !PsiUtil.isCompileStatic(variable)) {
                PsiType type2 = initializer2.getType();
                if (type2 == null) {
                    return;
                }
                PsiType valueType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
                this.processAssignment(varType, valueType, tuple, variable.getNameIdentifierGroovy());
                return;
            }
        }
        if ((initializer = variable.getInitializerGroovy()) == null) {
            return;
        }
        this.processAssignment(varType, initializer, variable.getNameIdentifierGroovy(), (PsiElement)variable);
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        super.visitListOrMap(listOrMap);
        Map<String, NamedArgumentDescriptor> descriptors = NamedArgumentUtilKt.getDescriptors(listOrMap);
        if (descriptors.isEmpty()) {
            return;
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        if (namedArguments.length == 0) {
            return;
        }
        this.checkNamedArguments(listOrMap, namedArguments, descriptors);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
    }
}

