/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ParameterCastFix;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyTypeCheckVisitorHelper {
    private static final Function<PsiType, PsiType> id = Function.ID;

    @Nullable
    @Contract(value="null -> null")
    protected static GrListOrMap getTupleInitializer(@Nullable GrExpression initializer) {
        if (initializer instanceof GrListOrMap && initializer.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)initializer.getReference()).getConstructedClassType() != null) {
            return (GrListOrMap)initializer;
        }
        return null;
    }

    @NotNull
    public static PsiElement getExpressionPartToHighlight(@NotNull GrExpression expr) {
        return expr instanceof GrClosableBlock ? ((GrClosableBlock)expr).getLBrace() : expr;
    }

    public static boolean hasErrorElements(@Nullable PsiElement e) {
        if (e == null) {
            return false;
        }
        for (PsiElement child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperatorWithSimpleTypes(GrBinaryExpression binary, GroovyResolveResult result2) {
        if (result2.getElement() != null && result2.isApplicable()) {
            return false;
        }
        GrExpression left = binary.getLeftOperand();
        GrExpression right = binary.getRightOperand();
        PsiType ltype = left.getType();
        PsiType rtype = right != null ? right.getType() : null;
        return TypesUtil.isNumericType(ltype) && (rtype == null || TypesUtil.isNumericType(rtype));
    }

    @NotNull
    public static LocalQuickFix[] genCastFixes(@NotNull GrSignature signature, @NotNull PsiType[] argumentTypes, @Nullable GrArgumentList argumentList) {
        if (argumentList == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        List<GrExpression> args = GroovyTypeCheckVisitorHelper.getExpressionArgumentsOfCall(argumentList);
        if (args == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<Pair<Integer, PsiType>> allErrors = new ArrayList<Pair<Integer, PsiType>>();
        List<GrSignature> signatures = GrClosureSignatureUtil.generateSimpleSignatures(Collections.singletonList(signature));
        for (GrSignature closureSignature : signatures) {
            GrClosureSignatureUtil.MapResultWithError mapResultWithError = GrClosureSignatureUtil.mapSimpleSignatureWithErrors(closureSignature, argumentTypes, id, argumentList, 255);
            if (mapResultWithError == null) continue;
            List<Pair<Integer, PsiType>> errors = mapResultWithError.getErrors();
            for (Pair<Integer, PsiType> error : errors) {
                if ((Integer)error.first == 0 && PsiImplUtil.hasNamedArguments(argumentList)) continue;
                allErrors.add(error);
            }
        }
        ArrayList<ParameterCastFix> fixes = new ArrayList<ParameterCastFix>();
        for (Pair pair : allErrors) {
            PsiType type2;
            if (args.size() <= (Integer)pair.first || pair.second == null || (type2 = PsiImplUtil.normalizeWildcardTypeByPosition((PsiType)pair.second, args.get((Integer)pair.first))) == null) continue;
            fixes.add(new ParameterCastFix((Integer)pair.first, type2));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    public static String buildArgTypesList(@NotNull PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = argTypes[i]) != null ? argType.getInternalCanonicalText() : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    public static String getLValueVarName(@NotNull PsiElement highlight) {
        PsiElement resolved;
        PsiElement parent2 = highlight.getParent();
        if (parent2 instanceof GrVariable) {
            return ((GrVariable)parent2).getName();
        }
        if (highlight instanceof GrReferenceExpression && parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == highlight && (resolved = ((GrReferenceExpression)highlight).resolve()) instanceof GrVariable && PsiUtil.isLocalVariable(resolved)) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    @Nullable
    public static List<GrExpression> getExpressionArgumentsOfCall(@NotNull GrArgumentList argumentList) {
        ArrayList args = ContainerUtil.newArrayList();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            if (arg instanceof GrSpreadArgument) {
                GrExpression spreaded = ((GrSpreadArgument)arg).getArgument();
                if (spreaded instanceof GrListOrMap && !((GrListOrMap)spreaded).isMap()) {
                    Collections.addAll(args, ((GrListOrMap)spreaded).getInitializers());
                    continue;
                }
                return null;
            }
            if (arg instanceof GrExpression) {
                args.add((GrExpression)arg);
                continue;
            }
            if (!(arg instanceof GrNamedArgument)) continue;
            args.add(((GrNamedArgument)arg).getExpression());
        }
        PsiElement parent2 = argumentList.getParent();
        if (parent2 instanceof GrIndexProperty && PsiUtil.isLValue((GroovyPsiElement)parent2)) {
            args.add(TypeInferenceHelper.getInitializerFor((GrExpression)parent2));
        } else if (parent2 instanceof GrMethodCallExpression) {
            ContainerUtil.addAll((Collection)args, (Object[])((GrMethodCallExpression)parent2).getClosureArguments());
        }
        return args;
    }
}

