/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class BoolUtils {
    public static boolean isNegation(@NotNull GrExpression exp) {
        if (!(exp instanceof GrUnaryExpression)) {
            return false;
        }
        GrUnaryExpression prefixExp = (GrUnaryExpression)exp;
        IElementType sign = prefixExp.getOperationTokenType();
        return GroovyTokenTypes.mBNOT.equals(sign);
    }

    public static boolean isTrue(@Nullable GrCondition condition) {
        if (condition == null) {
            return false;
        }
        return "true".equals(condition.getText());
    }

    public static boolean isFalse(GrCondition condition) {
        if (condition == null) {
            return false;
        }
        return "false".equals(condition.getText());
    }

    public static String getNegatedExpressionText(@NotNull GrExpression condition) {
        if (condition instanceof GrParenthesizedExpression) {
            GrExpression contentExpression = ((GrParenthesizedExpression)condition).getOperand();
            if (contentExpression == null) {
                return "()";
            }
            return '(' + BoolUtils.getNegatedExpressionText(contentExpression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            GrExpression negated = BoolUtils.getNegated(condition);
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static GrExpression getNegated(@NotNull GrExpression exp) {
        GrUnaryExpression prefixExp = (GrUnaryExpression)exp;
        GrExpression operand = prefixExp.getOperand();
        return (GrExpression)PsiUtil.skipParentheses(operand, false);
    }
}

