/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleConfigurationImporter;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;

public class GroovyCodeStyleImporter
implements CodeStyleConfigurationImporter<GroovyCodeStyleSettings> {
    public void processSettings(@NotNull GroovyCodeStyleSettings settings, @NotNull Map config) {
        this.asInt(config.get("CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND"), (Consumer<Integer>)((Consumer)it -> {
            settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = it;
        }));
        this.asBoolean(config.get("ALIGN_NAMED_ARGS_IN_MAP"), (Consumer<Boolean>)((Consumer)it -> {
            settings.ALIGN_NAMED_ARGS_IN_MAP = it;
        }));
    }

    public boolean canImport(@NotNull String langName) {
        return "groovy".equals(langName);
    }

    @NotNull
    public Class<GroovyCodeStyleSettings> getCustomClass() {
        return GroovyCodeStyleSettings.class;
    }

    @NotNull
    public Language getLanguage() {
        return GroovyLanguage.INSTANCE;
    }

    private void asInt(Object value, Consumer<Integer> consumer) {
        if (value instanceof Number) {
            consumer.consume((Object)((Number)value).intValue());
        }
    }

    private void asBoolean(Object value, Consumer<Boolean> consumer) {
        if (value instanceof Boolean) {
            consumer.consume((Object)((Boolean)value));
        }
    }
}

