/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.actions.GrExecuteCommandAction;

public final class GroovyConsoleRootType
extends ConsoleRootType {
    public static final AnAction EXECUTE_ACTION = new GrExecuteCommandAction();
    public static final String CONTENT_ID = "groovy_console";

    @NotNull
    public static GroovyConsoleRootType getInstance() {
        return (GroovyConsoleRootType)GroovyConsoleRootType.findByClass(GroovyConsoleRootType.class);
    }

    public GroovyConsoleRootType() {
        super("groovy", "Groovy consoles");
    }

    @NotNull
    public String getDefaultFileExtension() {
        return "groovy";
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        return !GroovyConsoleStateService.getInstance(project).isProjectConsole(element);
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        assert (id == CONTENT_ID);
        return CONTENT_ID;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (!Registry.is((String)"groovy.console.project.view.names")) {
            return null;
        }
        String name = file.getName();
        String moduleTitle = GroovyConsoleStateService.getInstance(project).getSelectedModuleTitle(file);
        return name.startsWith(CONTENT_ID) ? StringUtil.replace((String)name, (String)CONTENT_ID, (String)(moduleTitle == null ? "unknown" : moduleTitle)) : String.format("%s-%s", moduleTitle, name);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            EXECUTE_ACTION.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, fileEditor.getComponent());
        }
    }
}

