/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public class GroovyConsoleUtil {
    @NotNull
    public static String getDisplayGroovyVersion(@NotNull Module module) {
        String moduleGroovyHomePath = LibrariesUtil.getGroovyHomePath(module);
        boolean bundled = moduleGroovyHomePath == null || !GroovyConsoleUtil.hasGroovyAll(module);
        String version = bundled ? BundledGroovy.getBundledGroovyVersion() : GroovyConfigUtils.getInstance().getSDKVersion(moduleGroovyHomePath);
        StringBuilder result2 = new StringBuilder();
        if (bundled) {
            result2.append("Bundled ");
        }
        result2.append("Groovy");
        if (version != "undefined") {
            result2.append(" ").append(version);
        }
        return result2.toString();
    }

    static boolean hasGroovyAll(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null;
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, GroovyConsoleUtilKt.getApplicableModules(project), (Function<Module, String>)((Function)GroovyConsoleUtil::getDisplayGroovyVersion), consumer);
    }

    @NotNull
    public static String getTitle(@NotNull Module module) {
        return ModuleChooserUtil.formatModuleVersion(module, GroovyConsoleUtil.getDisplayGroovyVersion(module));
    }
}

