/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(GroovyFileType.GROOVY_FILE_TYPE);

    public GroovyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) throws NoDataException {
        GroovyPositionManager.checkGroovyFile(position);
        try {
            List<Location> locations;
            if (LOG.isDebugEnabled()) {
                LOG.debug("locationsOfLine: " + type2 + "; " + position);
            }
            int line = position.getLine() + 1;
            List<Location> list = locations = this.getDebugProcess().getVirtualMachineProxy().versionHigher("1.4") ? type2.locationsOfLine("Java", null, line) : type2.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            return locations;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
    }

    @Nullable
    private static GroovyPsiElement findReferenceTypeSourceImage(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        if (element == null) {
            return null;
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrFunctionalExpression.class, GrTypeDefinition.class});
    }

    @Nullable
    private static PsiClass findEnclosingTypeDefinition(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        do {
            if (!((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTypeDefinition.class, GroovyFileBase.class})) instanceof GroovyFileBase)) continue;
            return ((GroovyFileBase)element).getScriptClass();
        } while (!(element instanceof GrTypeDefinition) || ((GrTypeDefinition)element).isAnonymous());
        return (GrTypeDefinition)element;
    }

    private static void checkGroovyFile(@NotNull SourcePosition position) throws NoDataException {
        if (!(position.getFile() instanceof GroovyFileBase)) {
            throw NoDataException.INSTANCE;
        }
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPrepareRequest: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        String qName = GroovyPositionManager.getOuterClassName(position);
        if (qName != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, qName);
        }
        qName = GroovyPositionManager.findEnclosingName(position);
        if (qName == null) {
            throw NoDataException.INSTANCE;
        }
        ClassPrepareRequestor waitRequestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                if (!positionManager.locationsOfLine(referenceType, position).isEmpty()) {
                    requestor.processClassPrepare(debuggerProcess, referenceType);
                }
            }
        };
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(waitRequestor, qName + "$*");
    }

    @Nullable
    private static String findEnclosingName(@NotNull SourcePosition position) {
        return (String)ReadAction.compute(() -> {
            PsiClass typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
            if (typeDefinition != null) {
                return GroovyPositionManager.getClassNameForJvm(typeDefinition);
            }
            return GroovyPositionManager.getScriptQualifiedName(position);
        });
    }

    @Nullable
    private static String getOuterClassName(SourcePosition position) {
        return (String)ReadAction.compute(() -> {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition) {
                return GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
            }
            if (sourceImage == null) {
                return GroovyPositionManager.getScriptQualifiedName(position);
            }
            return null;
        });
    }

    @Nullable
    private static String getClassNameForJvm(@NotNull PsiClass typeDefinition) {
        String qname;
        String suffix = typeDefinition instanceof GrTypeDefinition && ((GrTypeDefinition)typeDefinition).isTrait() ? "$Trait$Helper" : "";
        PsiClass psiClass = typeDefinition.getContainingClass();
        if (psiClass != null) {
            String parent2 = GroovyPositionManager.getClassNameForJvm(psiClass);
            return parent2 == null ? null : parent2 + "$" + typeDefinition.getName() + suffix;
        }
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String s;
                String string = s = helper.isAppropriateScriptFile((GroovyFile)file) ? helper.customizeClassName(typeDefinition) : null;
                if (s == null) continue;
                return s;
            }
        }
        return (qname = typeDefinition.getQualifiedName()) == null ? null : qname + suffix;
    }

    @Nullable
    private static String getScriptQualifiedName(@NotNull SourcePosition position) {
        PsiFile file = position.getFile();
        if (file instanceof GroovyFile) {
            return GroovyPositionManager.getScriptFQName((GroovyFile)file);
        }
        return null;
    }

    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSourcePosition: " + location);
        }
        if ((psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location)) == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        return DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
    }

    @Nullable
    private PsiFile getPsiFileByLocation(@NotNull Project project, @Nullable Location location) {
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name().replace('/', '.');
        int dollar = originalQName.indexOf(36);
        String runtimeName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        String qName = GroovyPositionManager.getOriginalQualifiedName(refType, runtimeName);
        GlobalSearchScope searchScope = this.myDebugProcess.getSearchScope();
        GroovyShortNamesCache cache2 = GroovyShortNamesCache.getGroovyShortNamesCache(project);
        try {
            List<PsiClass> classes2 = cache2.getClassesByFQName(qName, searchScope, true);
            if (classes2.isEmpty()) {
                classes2 = cache2.getClassesByFQName(qName, searchScope, false);
            }
            if (classes2.isEmpty()) {
                classes2 = cache2.getClassesByFQName(qName, GlobalSearchScope.projectScope((Project)project), false);
            }
            if (classes2.isEmpty()) {
                classes2 = cache2.getClassesByFQName(qName, GroovyPositionManager.addModuleContent(searchScope), false);
            }
            if (!classes2.isEmpty()) {
                classes2.sort(PsiClassUtil.createScopeComparator((GlobalSearchScope)searchScope));
                PsiClass clazz = classes2.get(0);
                if (clazz != null) {
                    return clazz.getContainingFile();
                }
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            return null;
        }
        return GroovyPositionManager.getExtraScriptIfNotFound(project, refType, runtimeName, searchScope);
    }

    @Nullable
    private static PsiFile getExtraScriptIfNotFound(@NotNull Project project, @NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull GlobalSearchScope searchScope) {
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            PsiFile file;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (file = helper.getExtraScriptIfNotFound(refType, runtimeName, project, searchScope)) == null) continue;
            return file;
        }
        return null;
    }

    private static GlobalSearchScope addModuleContent(GlobalSearchScope scope) {
        Module module;
        if (scope instanceof ModuleWithDependenciesScope && !(module = ((ModuleWithDependenciesScope)scope).getModule()).isDisposed()) {
            return scope.uniteWith(module.getModuleContentWithDependenciesScope());
        }
        return scope;
    }

    private static String getOriginalQualifiedName(@NotNull ReferenceType refType, @NotNull String runtimeName) {
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            String originalScriptName;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (originalScriptName = helper.getOriginalScriptName(refType, runtimeName)) == null) continue;
            return originalScriptName;
        }
        return runtimeName;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        List result2 = (List)ReadAction.compute(() -> {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition && !((GrTypeDefinition)sourceImage).isAnonymous()) {
                String qName = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                if (qName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(qName);
                }
            } else if (sourceImage == null) {
                String scriptName = GroovyPositionManager.getScriptQualifiedName(position);
                if (scriptName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(scriptName);
                }
            } else {
                String enclosingName = GroovyPositionManager.findEnclosingName(position);
                if (enclosingName == null) {
                    return null;
                }
                List outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(enclosingName);
                ArrayList<ReferenceType> result1 = new ArrayList<ReferenceType>(outers.size());
                for (ReferenceType outer : outers) {
                    ReferenceType nested = this.findNested(outer, sourceImage, position);
                    if (nested == null) continue;
                    result1.add(nested);
                }
                return result1;
            }
            return null;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses = " + result2);
        }
        if (result2 == null) {
            throw NoDataException.INSTANCE;
        }
        return result2;
    }

    @Nullable
    private static String getScriptFQName(@NotNull GroovyFile groovyFile) {
        String packageName = groovyFile.getPackageName();
        String fileName = GroovyPositionManager.getRuntimeScriptName(groovyFile);
        return StringUtil.getQualifiedName((String)packageName, (String)fileName);
    }

    @NotNull
    private static String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        if (groovyFile.isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String runtimeScriptName;
                if (!helper.isAppropriateScriptFile(groovyFile) || (runtimeScriptName = helper.getRuntimeScriptName(groovyFile)) == null) continue;
                return runtimeScriptName;
            }
        }
        VirtualFile vFile = groovyFile.getVirtualFile();
        assert (vFile != null);
        return vFile.getNameWithoutExtension();
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, GroovyPsiElement toFind, SourcePosition classPosition) {
        VirtualMachineProxy vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, toFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (!fromClass.locationsOfLine(lineNumber).isEmpty()) {
                    return fromClass;
                }
                Iterator<Location> iterator2 = fromClass.allLineLocations().iterator();
                if (iterator2.hasNext()) {
                    Location location = iterator2.next();
                    SourcePosition candidateFirstPosition = SourcePosition.createFromLine((PsiFile)toFind.getContainingFile(), (int)(location.lineNumber() - 1));
                    if (toFind.equals(GroovyPositionManager.findReferenceTypeSourceImage(candidateFirstPosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        return ourFileTypes;
    }
}

