/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DGMFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final DGMFileType INSTANCE = new DGMFileType();

    private DGMFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "DGM File Type";
    }

    @NotNull
    public String getDescription() {
        return "Groovy extension module descriptor file";
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return PropertiesFileType.INSTANCE.getIcon();
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        VirtualFile gParent;
        VirtualFile parent2 = file.getParent();
        if (parent2 == null) {
            return false;
        }
        CharSequence parentName = parent2.getNameSequence();
        if ((Comparing.equal((CharSequence)"services", (CharSequence)parentName) || Comparing.equal((CharSequence)"groovy", (CharSequence)parentName)) && (gParent = parent2.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence())) {
            String fileName = file.getName();
            return fileName.equals("org.codehaus.groovy.runtime.ExtensionModule");
        }
        return false;
    }
}

