/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GroovyLiteralCopyPasteProcessor
extends StringLiteralCopyPasteProcessor {
    private static final Logger LOG = Logger.getInstance(GroovyLiteralCopyPasteProcessor.class);

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        return false;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        return node != null && (TokenSets.STRING_LITERALS.contains(node.getElementType()) || node.getElementType() == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_INJECTION || node.getElementType() == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_CONTENT);
    }

    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        if (node == null) {
            return null;
        }
        IElementType tokenType = node.getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            String text = token.getText();
            if (text == null) {
                return null;
            }
            return GroovyStringLiteralManipulator.getLiteralRange(text).shiftRight(node.getStartOffset());
        }
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT) {
            return token.getTextRange();
        }
        return null;
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelectionStart = file.findElementAt(selectionStart);
        if (elementAtSelectionStart == null) {
            return null;
        }
        IElementType elementType = elementAtSelectionStart.getNode().getElementType();
        if ((elementType == GroovyTokenTypes.mREGEX_END || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END || elementType == GroovyTokenTypes.mGSTRING_END) && elementAtSelectionStart.getTextOffset() == selectionStart) {
            if ((elementAtSelectionStart = elementAtSelectionStart.getPrevSibling()) == null) {
                return null;
            }
            elementType = elementAtSelectionStart.getNode().getElementType();
        }
        if (elementType == GroovyTokenTypes.mDOLLAR) {
            elementAtSelectionStart = elementAtSelectionStart.getParent();
            elementType = elementAtSelectionStart.getNode().getElementType();
        }
        if (!this.isStringLiteral(elementAtSelectionStart)) {
            return null;
        }
        if (elementAtSelectionStart.getTextRange().getEndOffset() < selectionEnd) {
            PsiElement elementAtSelectionEnd = file.findElementAt(selectionEnd);
            if (elementAtSelectionEnd == null) {
                return null;
            }
            if (elementAtSelectionEnd.getNode().getElementType() == elementType && elementAtSelectionEnd.getTextRange().getStartOffset() < selectionEnd) {
                return elementAtSelectionStart;
            }
        }
        TextRange textRange = elementAtSelectionStart.getTextRange();
        if (elementType == GroovyTokenTypes.mREGEX_CONTENT || elementType == GroovyTokenTypes.mGSTRING_CONTENT || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || elementType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_INJECTION) {
            ++selectionStart;
            --selectionEnd;
        }
        if (textRange.getLength() > 0 && (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset())) {
            return null;
        }
        if (elementType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_CONTENT) {
            elementAtSelectionStart = elementAtSelectionStart.getFirstChild();
        }
        return elementAtSelectionStart;
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        PsiElement parent2 = GrStringUtil.findContainingLiteral(token);
        String text = parent2.getText();
        if (text.contains("'''") || text.contains("\"\"\"")) {
            return "\n";
        }
        IElementType type2 = token.getNode().getElementType();
        if (type2 == GroovyElementTypes.STRING_DQ || type2 == GroovyElementTypes.STRING_TDQ || type2 == GroovyTokenTypes.mGSTRING_CONTENT) {
            return super.getLineBreaker(token);
        }
        if (type2 == GroovyElementTypes.STRING_SQ || type2 == GroovyElementTypes.STRING_TSQ) {
            return super.getLineBreaker(token).replace('\"', '\'');
        }
        return "\n";
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (token == null) {
            return text;
        }
        if (this.isStringLiteral(token)) {
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = this.getLineBreaker(token);
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                buffer.append(this.escapeCharCharacters(lines[i], token));
                if (i == lines.length - 1 && (!"\n".equals(breaker) || !text.endsWith("\n"))) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        }
        return text;
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        if (s.isEmpty()) {
            return s;
        }
        IElementType tokenType = token.getNode().getElementType();
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT || tokenType == GroovyTokenTypes.mREGEX_LITERAL) {
            return GrStringUtil.escapeSymbolsForSlashyStrings(s);
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            return GrStringUtil.escapeSymbolsForDollarSlashyStrings(s);
        }
        if (tokenType == GroovyTokenTypes.mGSTRING_CONTENT || tokenType == GroovyElementTypes.STRING_DQ || tokenType == GroovyElementTypes.STRING_TDQ || tokenType == org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.GSTRING_INJECTION) {
            boolean singleLine = !GrStringUtil.findContainingLiteral(token).getText().contains("\"\"\"");
            StringBuilder b = new StringBuilder();
            GrStringUtil.escapeStringCharacters(s.length(), s, singleLine ? "\"" : "", singleLine, true, b);
            GrStringUtil.unescapeCharacters(b, singleLine ? "'" : "'\"", true);
            LOG.assertTrue(b.length() > 0, (Object)("s=" + s));
            for (int i = b.length() - 2; i >= 0; --i) {
                char next;
                if (b.charAt(i) != '$' || (next = b.charAt(i + 1)) == '{' || Character.isLetter(next)) continue;
                b.insert(i, '\\');
            }
            if (b.charAt(b.length() - 1) == '$') {
                b.insert(b.length() - 1, '\\');
            }
            return b.toString();
        }
        if (tokenType == GroovyElementTypes.STRING_SQ || tokenType == GroovyElementTypes.STRING_TSQ) {
            return GrStringUtil.escapeSymbolsForString(s, !token.getText().contains("'''"), false);
        }
        return super.escapeCharCharacters(s, token);
    }

    @NotNull
    protected String unescape(String s, PsiElement token) {
        IElementType tokenType = token.getNode().getElementType();
        if (tokenType == GroovyTokenTypes.mREGEX_CONTENT || tokenType == GroovyTokenTypes.mREGEX_LITERAL) {
            return GrStringUtil.unescapeSlashyString(s);
        }
        if (tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT || tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            return GrStringUtil.unescapeDollarSlashyString(s);
        }
        if (tokenType == GroovyTokenTypes.mGSTRING_CONTENT || tokenType == GroovyElementTypes.STRING_DQ || tokenType == GroovyElementTypes.STRING_TDQ) {
            return GrStringUtil.unescapeString(s);
        }
        if (tokenType == GroovyElementTypes.STRING_SQ || tokenType == GroovyElementTypes.STRING_TSQ) {
            return GrStringUtil.unescapeString(s);
        }
        return super.unescape(s, token);
    }
}

