/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static boolean isReadOnly(@NotNull Editor editor) {
        if (editor.isViewer()) {
            return true;
        }
        Document document = editor.getDocument();
        return !document.isWritable();
    }

    public static boolean canBeInvoked(Editor editor, Project project) {
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        return HandlerUtils.getPsiFile(editor, project) != null;
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, Project project) {
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
    }
}

