/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GStringBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        if (c != '{') {
            return;
        }
        if (!(file instanceof GroovyFile)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (offset < 1) {
            return;
        }
        HighlighterIterator iterator2 = highlighter.createIterator(offset);
        if (iterator2.getTokenType() != GroovyTokenTypes.mRCURLY) {
            return;
        }
        iterator2.retreat();
        if (iterator2.getStart() < 1 || iterator2.getTokenType() != GroovyTokenTypes.mLCURLY) {
            return;
        }
        editor.getDocument().deleteString(offset, offset + 1);
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        return false;
    }
}

