/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GrJoinLinesHandlerBase
implements JoinRawLinesHandlerDelegate {
    private static final boolean BACK = false;
    private static final boolean FORWARD = false;

    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (!(file instanceof GroovyFileBase)) {
            return -1;
        }
        PsiElement element = file.findElementAt(end);
        GrStatementOwner statementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrStatementOwner.class, (boolean)true, (Class[])new Class[]{GroovyFileBase.class});
        if (statementOwner == null) {
            return -1;
        }
        GrStatement first = null;
        GrStatement last = null;
        for (PsiElement child = statementOwner.getFirstChild(); child != null; child = child.getNextSibling()) {
            TextRange range = child.getTextRange();
            if (range.getEndOffset() == start) {
                first = GrJoinLinesHandlerBase.skipSemicolonsAndWhitespaces(child, false);
                continue;
            }
            if (range.getStartOffset() != end) continue;
            last = GrJoinLinesHandlerBase.skipSemicolonsAndWhitespaces(child, false);
        }
        if (last == null || first == null) {
            return -1;
        }
        return this.tryJoinStatements(first, last);
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        return -1;
    }

    @Nullable
    private static GrStatement skipSemicolonsAndWhitespaces(PsiElement child, boolean forward) {
        while (child != null && !(child instanceof GrStatement)) {
            IElementType type2 = child.getNode().getElementType();
            if (type2 != GroovyTokenTypes.mSEMI && (type2 != TokenType.WHITE_SPACE || child.getText().contains("\n"))) {
                return null;
            }
            child = forward ? child.getNextSibling() : child.getPrevSibling();
        }
        return (GrStatement)child;
    }

    public abstract int tryJoinStatements(@NotNull GrStatement var1, @NotNull GrStatement var2);
}

