/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;

public class GroovyDocParamsSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof GrDocMethodParams;
    }

    public List<TextRange> select(@NotNull PsiElement element, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        GrDocMethodParams params;
        TextRange range;
        List result2 = super.select(element, editorText, cursorOffset, editor);
        if (element instanceof GrDocMethodParams && (range = (params = (GrDocMethodParams)element).getTextRange()).contains(cursorOffset)) {
            PsiElement leftParen = params.getLeftParen();
            PsiElement rightParen = params.getRightParen();
            int leftOffset = leftParen.getTextOffset();
            if (rightParen != null) {
                if (leftOffset + 1 < rightParen.getTextOffset()) {
                    int rightOffset = rightParen.getTextRange().getEndOffset();
                    range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, rightOffset - 1);
                    result2.add(range);
                }
            } else {
                range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, element.getTextRange().getEndOffset());
                result2.add(range);
            }
        }
        return result2;
    }
}

