/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;

public class GroovyMembersWithDocSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof GrDocComment || e instanceof GrDocCommentOwner;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        GrDocCommentOwner owner;
        GrDocComment doc;
        if (e instanceof GrDocComment) {
            doc = (GrDocComment)e;
            owner = GrDocCommentUtil.findDocOwner(doc);
        } else {
            owner = (GrDocCommentOwner)e;
            doc = GrDocCommentUtil.findDocComment(owner);
        }
        if (doc == null || owner == null) {
            return Collections.emptyList();
        }
        TextRange range = new TextRange(doc.getTextRange().getStartOffset(), owner.getTextRange().getEndOffset());
        return ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)range, (boolean)true);
    }
}

