/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"isInteractionCall", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isInteractionCallUp", "isInteractionDown", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "isInteractionPart", "isInteractionUp", "isInteractionWithCardinalityDown", "isInteractionWithResponseDown", "isMultiplication", "isRightShift", "intellij.groovy.psi"})
public final class InteractionsKt {
    public static final boolean isInteractionPart(@NotNull GrExpression $receiver) {
        return InteractionsKt.isInteractionDown($receiver) && InteractionsKt.isInteractionUp($receiver) || InteractionsKt.isInteractionCallUp($receiver);
    }

    private static final boolean isInteractionDown(@NotNull GrExpression $receiver) {
        return $receiver instanceof GrBinaryExpression && InteractionsKt.isInteractionDown((GrBinaryExpression)$receiver);
    }

    private static final boolean isInteractionDown(@NotNull GrBinaryExpression $receiver) {
        return InteractionsKt.isInteractionWithResponseDown($receiver) || InteractionsKt.isInteractionWithCardinalityDown($receiver);
    }

    private static final boolean isInteractionWithResponseDown(@NotNull GrBinaryExpression $receiver) {
        return InteractionsKt.isRightShift($receiver) && (InteractionsKt.isInteractionDown($receiver.getLeftOperand()) || InteractionsKt.isInteractionCall($receiver.getLeftOperand()));
    }

    private static final boolean isInteractionWithCardinalityDown(@NotNull GrBinaryExpression $receiver) {
        return InteractionsKt.isMultiplication($receiver) && InteractionsKt.isInteractionCall($receiver.getRightOperand());
    }

    private static final boolean isInteractionCall(@Nullable GrExpression $receiver) {
        return $receiver instanceof GrReferenceExpression || $receiver instanceof GrMethodCall || $receiver instanceof GrNewExpression;
    }

    private static final boolean isInteractionUp(@NotNull GrExpression $receiver) {
        for (Pair pair : SequencesKt.zipWithNext((Sequence)PsiTreeUtilKt.parents((PsiElement)$receiver))) {
            PsiElement lastParent = (PsiElement)pair.component1();
            PsiElement parent2 = (PsiElement)pair.component2();
            if (parent2 instanceof GrBinaryExpression) {
                if (((GrBinaryExpression)parent2).getLeftOperand() == lastParent && InteractionsKt.isRightShift((GrBinaryExpression)parent2)) continue;
                return false;
            }
            return PsiUtil.isExpressionStatement(lastParent);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInteractionCallUp(@NotNull GrExpression $receiver) {
        PsiElement psiElement;
        if (!InteractionsKt.isInteractionCall($receiver)) return false;
        PsiElement it = psiElement = $receiver.getParent();
        boolean bl = false;
        if (!(it instanceof GrBinaryExpression)) return false;
        if (((GrBinaryExpression)it).getRightOperand() != $receiver) return false;
        if (!InteractionsKt.isMultiplication((GrBinaryExpression)it)) return false;
        if (!InteractionsKt.isInteractionUp((GrExpression)it)) return false;
        return true;
    }

    private static final boolean isRightShift(@NotNull GrBinaryExpression $receiver) {
        IElementType iElementType;
        IElementType it = iElementType = $receiver.getOperationTokenType();
        boolean bl = false;
        return it == GroovyElementTypes.RIGHT_SHIFT_SIGN || it == GroovyElementTypes.RIGHT_SHIFT_UNSIGNED_SIGN;
    }

    private static final boolean isMultiplication(@NotNull GrBinaryExpression $receiver) {
        return $receiver.getOperationTokenType() == GroovyElementTypes.T_STAR;
    }
}

