/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class SpockMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class);
            if (method == null) {
                return;
            }
            if (aClass != method.getContainingClass()) {
                return;
            }
            Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
            String nameHint2 = ResolveUtil.getNameHint(processor);
            if (nameHint2 == null) {
                for (SpockVariableDescriptor spockVar : cachedValue.values()) {
                    if (processor.execute((PsiElement)spockVar.getVariable(), state)) continue;
                    return;
                }
            } else {
                SpockVariableDescriptor spockVar = cachedValue.get(nameHint2);
                if (spockVar != null && spockVar.getNavigationElement() != place) {
                    processor.execute((PsiElement)spockVar.getVariable(), state);
                }
            }
        }
    }

    @Override
    public String getParentClassName() {
        return "spock.lang.Specification";
    }
}

