/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodInfo;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovyNamedArgumentProvider {
    public static final ExtensionPointName<GroovyNamedArgumentProvider> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.namedArgumentProvider");

    public void getNamedArguments(@NotNull GrCall call, @NotNull GroovyResolveResult resolveResult2, @Nullable String argumentName, boolean forCompletion, @NotNull Map<String, NamedArgumentDescriptor> result2) {
    }

    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedArguments(@NotNull GrListOrMap literal) {
        return Collections.emptyMap();
    }

    @Nullable
    public static Map<String, NamedArgumentDescriptor> getNamedArgumentsFromAllProviders(@NotNull GrCall call, @Nullable String argumentName, boolean forCompletion) {
        HashMap<String, NamedArgumentDescriptor> namedArguments = new HashMap<String, NamedArgumentDescriptor>(){

            @Override
            public NamedArgumentDescriptor put(String key, NamedArgumentDescriptor value) {
                NamedArgumentDescriptor oldValue = super.put(key, value);
                if (oldValue != null) {
                    super.put(key, oldValue);
                }
                return oldValue;
            }
        };
        GroovyResolveResult[] callVariants = call.getCallVariants(null);
        if (callVariants.length == 0 || PsiUtil.isSingleBindingVariant(callVariants)) {
            for (GroovyNamedArgumentProvider namedArgumentProvider : (GroovyNamedArgumentProvider[])EP_NAME.getExtensions()) {
                namedArgumentProvider.getNamedArguments(call, EmptyGroovyResolveResult.INSTANCE, argumentName, forCompletion, (Map<String, NamedArgumentDescriptor>)namedArguments);
            }
        } else {
            boolean mapExpected = false;
            for (GroovyResolveResult result2 : callVariants) {
                for (GroovyNamedArgumentProvider namedArgumentProvider : (GroovyNamedArgumentProvider[])EP_NAME.getExtensions()) {
                    namedArgumentProvider.getNamedArguments(call, result2, argumentName, forCompletion, (Map<String, NamedArgumentDescriptor>)namedArguments);
                }
                PsiElement element = result2.getElement();
                if (element instanceof GrAccessorMethod) continue;
                if (element instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)element;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (!method.isConstructor() && (parameters.length <= 0 || !GroovyNamedArgumentProvider.canBeMap(parameters[0]))) continue;
                    mapExpected = true;
                    for (GroovyMethodInfo methodInfo : GroovyMethodInfo.getInfos(method)) {
                        if (methodInfo.getNamedArguments() == null && !methodInfo.isNamedArgumentProviderDefined() || !methodInfo.isApplicable(method)) continue;
                        if (methodInfo.isNamedArgumentProviderDefined()) {
                            methodInfo.getNamedArgProvider().getNamedArguments(call, result2, argumentName, forCompletion, (Map<String, NamedArgumentDescriptor>)namedArguments);
                        }
                        if (methodInfo.getNamedArguments() == null) continue;
                        namedArguments.putAll(methodInfo.getNamedArguments());
                    }
                }
                if (!(element instanceof GrVariable) || !InheritanceUtil.isInheritor((PsiType)((GrVariable)element).getTypeGroovy(), (String)"groovy.lang.Closure")) continue;
                mapExpected = true;
            }
            if (!mapExpected && namedArguments.isEmpty()) {
                return null;
            }
        }
        return namedArguments;
    }

    private static boolean canBeMap(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (parameter instanceof GrParameter && type2.equalsToText("java.lang.Object") && ((GrParameter)parameter).getTypeElementGroovy() == null) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }
}

