/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;

public class GrLiteralMethodSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        PsiMethod[] psiMethodArray;
        PsiMethod method = p.getMethod();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        String name = method.getName();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        boolean strictSignatureSearch = p.isStrictSignatureSearch();
        if (strictSignatureSearch) {
            PsiMethod[] psiMethodArray2 = new PsiMethod[1];
            psiMethodArray = psiMethodArray2;
            psiMethodArray2[0] = method;
        } else {
            psiMethodArray = aClass.findMethodsByName(name, false);
        }
        PsiMethod[] methods = psiMethodArray;
        SearchScope accessScope = GroovyScopeUtil.getEffectiveScope(methods);
        SearchScope restrictedByAccess = GroovyScopeUtil.restrictScopeToGroovyFiles(p.getEffectiveSearchScope(), accessScope);
        String textToSearch = GrLiteralMethodSearcher.findLongestWord(name);
        p.getOptimizer().searchWord(textToSearch, restrictedByAccess, (short)4, true, (PsiElement)method, (RequestResultProcessor)new MethodTextOccurrenceProcessor(aClass, strictSignatureSearch, methods));
    }

    @NotNull
    private static String findLongestWord(@NotNull String sequence) {
        List words = StringUtil.getWordsIn((String)sequence);
        if (words.isEmpty()) {
            return sequence;
        }
        String longest = (String)words.get(0);
        for (String word : words) {
            if (word.length() <= longest.length()) continue;
            longest = word;
        }
        return longest;
    }

    public GrLiteralMethodSearcher() {
        super(true);
    }
}

