/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class LiteralConstructorReference
extends PsiReferenceBase.Poly<GrListOrMap> {
    public LiteralConstructorReference(@NotNull GrListOrMap element) {
        super((PsiElement)element, TextRange.from((int)0, (int)0), false);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.getElement();
    }

    @Nullable
    public PsiClassType getConstructedClassType() {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)this.getElement(), () -> CachedValueProvider.Result.create((Object)this.inferConversionType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PsiClassType inferConversionType() {
        PsiType ownType;
        PsiType unboxed;
        GrListOrMap listOrMap = (GrListOrMap)this.getElement();
        PsiClassType conversionType = LiteralConstructorReference.getTargetConversionType(listOrMap);
        if (conversionType == null) {
            return null;
        }
        if (listOrMap.isEmpty() && (PsiType.BOOLEAN.equals((Object)(unboxed = TypesUtil.unboxPrimitiveTypeWrapper((PsiType)conversionType))) || PsiType.CHAR.equals((Object)unboxed))) {
            return null;
        }
        PsiType type2 = listOrMap.getType();
        Object object = ownType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : type2;
        if (ownType != null && TypesUtil.isAssignableWithoutConversions((PsiType)conversionType.rawType(), ownType)) {
            return null;
        }
        PsiClass resolved = conversionType.resolve();
        if (resolved != null) {
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Set")) {
                return null;
            }
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.List")) {
                return null;
            }
        }
        return conversionType;
    }

    @Nullable
    public static PsiClassType getTargetConversionType(@NotNull GrExpression expression) {
        PsiElement parent2 = PsiUtil.skipParentheses(expression.getParent(), true);
        PsiType type2 = null;
        if (parent2 instanceof GrSafeCastExpression) {
            type2 = ((GrSafeCastExpression)parent2).getType();
        } else if (parent2 instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent2).getRValue(), (PsiElement)expression, (boolean)false)) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent2).getLValue(), false);
            if (lValue instanceof GrReferenceExpression) {
                type2 = ((GrReferenceExpression)lValue).getNominalType();
            }
        } else if (parent2 instanceof GrVariable) {
            type2 = ((GrVariable)parent2).getDeclaredType();
        } else if (parent2 instanceof GrNamedArgument) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes(expression)) {
                if ((expected = LiteralConstructorReference.filterOutTrashTypes(expected)) == null) continue;
                return (PsiClassType)expected;
            }
        } else {
            GrControlFlowOwner controlFlowOwner = ControlFlowUtils.findControlFlowOwner(expression);
            if (controlFlowOwner instanceof GrOpenBlock && controlFlowOwner.getParent() instanceof GrMethod && ControlFlowUtils.isReturnValue(expression, controlFlowOwner) && (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(type2 = ((GrMethod)controlFlowOwner.getParent()).getReturnType())) || TypesUtil.isEnum(type2) || PsiUtil.isCompileStatic(expression) || TypesUtil.isClassType(type2, "java.lang.String", "java.lang.Class"))) {
                type2 = null;
            }
        }
        if (PsiType.BOOLEAN.equals((Object)type2)) {
            type2 = TypesUtil.boxPrimitiveType(type2, expression.getManager(), expression.getResolveScope());
        }
        return LiteralConstructorReference.filterOutTrashTypes(type2);
    }

    @Nullable
    private static PsiClassType filterOutTrashTypes(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (type2.equalsToText("java.lang.Object")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type2, "java.lang.Class")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type2, "java.util.Map")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type2, "java.util.HashMap")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type2, "java.util.List")) {
            return null;
        }
        PsiType erased = TypeConversionUtil.erasure((PsiType)type2);
        if (erased == null || erased.equalsToText("java.lang.Object")) {
            return null;
        }
        return (PsiClassType)type2;
    }

    @NotNull
    public GrExpression[] getCallArguments() {
        GrListOrMap literal = (GrListOrMap)this.getElement();
        if (literal.isMap()) {
            GrNamedArgument argument = literal.findNamedArgument("super");
            if (argument != null) {
                GrExpression expression = argument.getExpression();
                if (expression instanceof GrListOrMap && !((GrListOrMap)expression).isMap()) {
                    return ((GrListOrMap)expression).getInitializers();
                }
                if (expression != null) {
                    return new GrExpression[]{expression};
                }
                return GrExpression.EMPTY_ARRAY;
            }
            return new GrExpression[]{literal};
        }
        return literal.getInitializers();
    }

    @NotNull
    private PsiType[] getCallArgumentTypes() {
        Object[] arguments2 = this.getCallArguments();
        return (PsiType[])ContainerUtil.map2Array((Object[])arguments2, PsiType.class, (Function)((NullableFunction)grExpression -> grExpression.getType()));
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult result2;
        PsiClassType type2 = this.getConstructedClassType();
        if (type2 == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        GroovyResolveResult[] constructorCandidates = PsiUtil.getConstructorCandidates(type2, this.getCallArgumentTypes(), (GroovyPsiElement)this.getElement());
        if (constructorCandidates.length == 0 && (result2 = GroovyResolveResultImpl.from(classResolveResult)) != EmptyGroovyResolveResult.INSTANCE) {
            return new GroovyResolveResult[]{result2};
        }
        return constructorCandidates;
    }
}

