/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.HashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlignmentProvider {
    private final Map<PsiElement, Set<PsiElement>> myTree = new HashMap<PsiElement, Set<PsiElement>>();
    private final Map<Set<PsiElement>, Alignment> myAlignments = new HashMap<Set<PsiElement>, Alignment>();
    private final Map<Set<PsiElement>, Boolean> myAllowBackwardShift = new HashMap<Set<PsiElement>, Boolean>();
    private final Map<Set<PsiElement>, Alignment.Anchor> myAnchor = new HashMap<Set<PsiElement>, Alignment.Anchor>();

    public void addPair(@NotNull PsiElement e1, @NotNull PsiElement e2, @Nullable Boolean allowBackwardShift) {
        this.addPair(e1, e2, allowBackwardShift, null);
    }

    public void addPair(@NotNull PsiElement e1, @NotNull PsiElement e2, @Nullable Boolean allowBackwardShift, @Nullable Alignment.Anchor anchor) {
        assert (e1 != e2);
        Set<PsiElement> set1 = this.myTree.get(e1);
        Set<PsiElement> set2 = this.myTree.get(e2);
        if (set1 != null && set2 != null) {
            assert (!this.myAlignments.containsKey(set1) || !this.myAlignments.containsKey(set2));
            assert (this.myAllowBackwardShift.get(set1).booleanValue() == this.myAllowBackwardShift.get(set2).booleanValue());
            assert (this.myAnchor.get(set1) == this.myAnchor.get(set2));
            if (allowBackwardShift != null) assert (this.myAllowBackwardShift.get(set1).booleanValue() == allowBackwardShift.booleanValue());
            if (anchor != null) assert (this.myAnchor.get(set1) == anchor);
            if (this.myAlignments.containsKey(set2)) {
                this.addSet(set1, set2);
            } else {
                set1.addAll(set2);
                this.addSet(set2, set1);
            }
        } else if (set1 != null) {
            this.addElement(e2, allowBackwardShift, anchor, set1);
        } else if (set2 != null) {
            this.addElement(e1, allowBackwardShift, anchor, set2);
        } else {
            HashSet<PsiElement> set = AlignmentProvider.createHashSet();
            this.addInternal((Set<PsiElement>)set, e1);
            this.addInternal((Set<PsiElement>)set, e2);
            this.myAllowBackwardShift.put((Set<PsiElement>)set, allowBackwardShift);
            this.myAnchor.put((Set<PsiElement>)set, anchor);
        }
    }

    private void addElement(PsiElement e, Boolean allowBackwardShift, Alignment.Anchor anchor, Set<PsiElement> set) {
        if (allowBackwardShift != null) assert (this.myAllowBackwardShift.get(set).booleanValue() == allowBackwardShift.booleanValue());
        if (anchor != null) assert (this.myAnchor.get(set) == anchor);
        this.addInternal(set, e);
    }

    private void addSet(Set<PsiElement> set1, Set<PsiElement> set2) {
        Iterator<PsiElement> iterator2 = set1.iterator();
        while (iterator2.hasNext()) {
            PsiElement element = iterator2.next();
            iterator2.remove();
            this.addInternal(set2, element);
        }
    }

    private void addInternal(@NotNull Set<PsiElement> set, @NotNull PsiElement element) {
        this.myTree.put(element, set);
        set.add(element);
    }

    @NotNull
    private static HashSet<PsiElement> createHashSet() {
        return new HashSet<PsiElement>(){
            private final int myhash = new Object().hashCode();

            public int hashCode() {
                return this.myhash;
            }
        };
    }

    public void addPair(@NotNull ASTNode node1, @NotNull ASTNode node2, boolean allowBackwardShift) {
        this.addPair(node1.getPsi(), node2.getPsi(), (Boolean)allowBackwardShift);
    }

    private void add(@NotNull PsiElement element, boolean allowBackwardShift) {
        this.add(element, allowBackwardShift, Alignment.Anchor.LEFT);
    }

    private void add(@NotNull PsiElement element, boolean allowBackwardShift, @NotNull Alignment.Anchor anchor) {
        if (this.myTree.get(element) != null) {
            return;
        }
        HashSet<PsiElement> set = AlignmentProvider.createHashSet();
        set.add((Object)element);
        this.myTree.put(element, (Set<PsiElement>)set);
        this.myAllowBackwardShift.put((Set<PsiElement>)set, allowBackwardShift);
        this.myAnchor.put((Set<PsiElement>)set, anchor);
    }

    @Nullable
    public Alignment getAlignment(@NotNull PsiElement e) {
        Set<PsiElement> set = this.myTree.get(e);
        if (set == null) {
            return null;
        }
        Alignment alignment = this.myAlignments.get(set);
        if (alignment != null) {
            return alignment;
        }
        Alignment.Anchor anchor = this.myAnchor.get(set);
        if (anchor == null) {
            this.myAnchor.put(set, Alignment.Anchor.LEFT);
            anchor = Alignment.Anchor.LEFT;
        }
        alignment = Alignment.createAlignment((boolean)this.myAllowBackwardShift.get(set), (Alignment.Anchor)anchor);
        this.myAlignments.put(set, alignment);
        return alignment;
    }

    @NotNull
    public Aligner createAligner(boolean allowBackwardShift) {
        return new Aligner(allowBackwardShift, Alignment.Anchor.LEFT);
    }

    @NotNull
    public Aligner createAligner(PsiElement element, boolean allowBackwardShift, Alignment.Anchor anchor) {
        Aligner aligner = new Aligner(allowBackwardShift, anchor);
        aligner.append(element);
        return aligner;
    }

    public class Aligner {
        private PsiElement myRef = null;
        private final boolean allowBackwardShift;
        @NotNull
        private final Alignment.Anchor myAnchor;

        private Aligner(@NotNull boolean allowBackwardShift, Alignment.Anchor anchor) {
            this.allowBackwardShift = allowBackwardShift;
            this.myAnchor = anchor;
        }

        public void append(@Nullable PsiElement element) {
            if (element == null) {
                return;
            }
            if (this.myRef == null) {
                this.myRef = element;
                AlignmentProvider.this.add(element, this.allowBackwardShift, this.myAnchor);
            } else {
                AlignmentProvider.this.addPair(this.myRef, element, this.allowBackwardShift, this.myAnchor);
            }
        }
    }
}

