/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GppClosureParameterTypeProvider
extends AbstractClosureParameterEnhancer {
    @Override
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        GrListOrMap list;
        Pair<PsiMethod, PsiSubstitutor> pair;
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GrNamedArgument && (pair = GppClosureParameterTypeProvider.getOverriddenMethod((GrNamedArgument)parent2)) != null) {
            PsiParameter[] parameters = ((PsiMethod)pair.first).getParameterList().getParameters();
            if (parameters.length > index) {
                return ((PsiSubstitutor)pair.second).substitute(parameters[index].getType());
            }
            return null;
        }
        if (parent2 instanceof GrListOrMap && !(list = (GrListOrMap)parent2).isMap()) {
            PsiType listType = list.getType();
            int argIndex = Arrays.asList(list.getInitializers()).indexOf(expression);
            assert (argIndex >= 0);
            if (listType instanceof GrTupleType) {
                for (PsiType type2 : GroovyExpectedTypesProvider.getDefaultExpectedTypes(list)) {
                    GroovyResolveResult[] candidates;
                    if (!(type2 instanceof PsiClassType)) continue;
                    for (GroovyResolveResult resolveResult2 : candidates = PsiUtil.getConstructorCandidates((PsiClassType)type2, ((GrTupleType)listType).getComponentTypesArray(), expression)) {
                        PsiType toCastTo;
                        PsiType suggestion;
                        PsiParameter[] parameters;
                        PsiElement method = resolveResult2.getElement();
                        if (!(method instanceof PsiMethod) || !((PsiMethod)method).isConstructor() || (parameters = ((PsiMethod)method).getParameterList().getParameters()).length <= argIndex || (suggestion = GppClosureParameterTypeProvider.getSingleMethodParameterType(toCastTo = resolveResult2.getSubstitutor().substitute(parameters[argIndex].getType()), index, expression)) == null) continue;
                        return suggestion;
                    }
                }
            }
            return null;
        }
        for (PsiType constraint : GroovyExpectedTypesProvider.getDefaultExpectedTypes(expression)) {
            PsiType suggestion = GppClosureParameterTypeProvider.getSingleMethodParameterType(constraint, index, expression);
            if (suggestion == null) continue;
            return suggestion;
        }
        return null;
    }

    @Nullable
    public static Pair<PsiMethod, PsiSubstitutor> getOverriddenMethod(GrNamedArgument namedArgument) {
        return (Pair)ContainerUtil.getFirstItem(GppClosureParameterTypeProvider.getOverriddenMethodVariants(namedArgument), null);
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getOverriddenMethodVariants(GrNamedArgument namedArgument) {
        GrArgumentLabel label = namedArgument.getLabel();
        if (label == null) {
            return Collections.emptyList();
        }
        String methodName = label.getName();
        if (methodName == null) {
            return Collections.emptyList();
        }
        PsiElement map2 = namedArgument.getParent();
        if (map2 instanceof GrListOrMap && ((GrListOrMap)map2).isMap()) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes((GrExpression)map2)) {
                if (!(expected instanceof PsiClassType)) continue;
                List<Pair<PsiMethod, PsiSubstitutor>> pairs = GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor((PsiClassType)expected, false);
                return ContainerUtil.findAll(pairs, pair -> methodName.equals(((PsiMethod)pair.first).getName()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiType getSingleMethodParameterType(@Nullable PsiType type2, int index, @NotNull GrFunctionalExpression expression) {
        PsiType[] signature = GppClosureParameterTypeProvider.findSingleAbstractMethodSignature(type2);
        if (signature == null) {
            return null;
        }
        GrSignature closureSignature = GrClosureSignatureUtil.createSignature(expression);
        if (GrClosureSignatureUtil.isSignatureApplicable(Collections.singletonList(closureSignature), signature, expression)) {
            return signature.length > index ? signature[index] : PsiType.NULL;
        }
        return null;
    }

    @Nullable
    public static PsiType[] findSingleAbstractMethodSignature(@Nullable PsiType type2) {
        List<Pair<PsiMethod, PsiSubstitutor>> result2;
        if (type2 instanceof PsiClassType && !TypesUtil.isClassType(type2, "groovy.lang.Closure") && (result2 = GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor((PsiClassType)type2, true)).size() == 1) {
            return GppClosureParameterTypeProvider.getParameterTypes(result2.get(0));
        }
        return null;
    }

    public static PsiType[] getParameterTypes(Pair<PsiMethod, PsiSubstitutor> pair) {
        return (PsiType[])ContainerUtil.map2Array((Object[])((PsiMethod)pair.first).getParameterList().getParameters(), PsiType.class, psiParameter -> ((PsiSubstitutor)pair.second).substitute(psiParameter.getType()));
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplementInInheritor(PsiClassType classType, boolean toImplement) {
        PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
        PsiClass psiClass = resolveResult2.getElement();
        if (psiClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> over = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, false);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> impl = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, true);
        for (PsiMethod method : psiClass.getMethods()) {
            (method.hasModifierProperty("abstract") ? impl : over).add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
        }
        Iterator iterator2 = impl.iterator();
        while (iterator2.hasNext()) {
            Pair pair = (Pair)iterator2.next();
            if (!GppClosureParameterTypeProvider.hasTraitImplementation((PsiMethod)pair.first)) continue;
            iterator2.remove();
            over.add((Pair<PsiMethod, PsiSubstitutor>)pair);
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = toImplement ? impl : over;
        int resultSize = result2.size();
        for (int i = 0; i < resultSize; ++i) {
            Pair pair = (Pair)result2.get(i);
            result2.set(i, (Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)pair.first, (Object)resolveResult2.getSubstitutor().putAll((PsiSubstitutor)pair.second)));
        }
        return result2;
    }

    private static ArrayList<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplement(PsiClass psiClass, boolean toImplement) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (CandidateInfo info : OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)psiClass, (boolean)toImplement)) {
            result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
        }
        return result2;
    }

    private static boolean hasTraitImplementation(PsiMethod method) {
        return method.getModifierList().hasAnnotation("org.mbte.groovypp.runtime.HasDefaultImplementation");
    }
}

