/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GppTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        return position == GrTypeConverter.ApplicableTo.ASSIGNMENT;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (context instanceof GrListOrMap && context.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)context.getReference()).getConstructedClassType() != null) {
            return null;
        }
        if (actualType instanceof GrTupleType) {
            PsiType tupleComponent;
            PsiType[] parameters;
            GrTupleType tupleType = (GrTupleType)actualType;
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)targetType, (boolean)false);
            if (expectedComponent != null && GppTypeConverter.isMethodCallConversion(context) && (parameters = tupleType.getParameters()).length == 1 && (tupleComponent = parameters[0]) != null && TypesUtil.canAssign(expectedComponent, tupleComponent, context, GrTypeConverter.ApplicableTo.ASSIGNMENT) == ConversionResult.OK && GppTypeConverter.hasDefaultConstructor(targetType)) {
                return ConversionResult.OK;
            }
        }
        return null;
    }

    public static boolean isClosureOverride(PsiType[] methodParameters, GrClosureType closureType, GroovyPsiElement context) {
        List<GrSignature> signature = closureType.getSignatures();
        return methodParameters != null && GrClosureSignatureUtil.isSignatureApplicable(signature, methodParameters, context);
    }

    public static boolean hasDefaultConstructor(PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        return psiClass != null && PsiUtil.hasDefaultConstructor((PsiClass)psiClass, (boolean)true, (boolean)false);
    }
}

