/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertStringToMultilineIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertStringToMultilineIntention.class);
    public static final String hint = GroovyIntentionsBundle.message("convert.string.to.multiline.intention.name", new Object[0]);

    @Override
    protected void processIntention(@NotNull PsiElement element, final @NotNull Project project, final Editor editor) throws IncorrectOperationException {
        List expressions = editor.getSelectionModel().hasSelection() ? Collections.singletonList((GrExpression)element) : (List)ReadAction.compute(() -> ConvertStringToMultilineIntention.collectExpressions(element));
        if (expressions.size() == 1) {
            this.invokeImpl((GrExpression)expressions.get(0), project, editor);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.invokeImpl((GrExpression)expressions.get(expressions.size() - 1), project, editor);
        } else {
            Pass<GrExpression> callback = new Pass<GrExpression>(){

                public void pass(GrExpression selectedValue) {
                    ConvertStringToMultilineIntention.this.invokeImpl(selectedValue, project, editor);
                }
            };
            Function renderer = grExpression -> grExpression.getText();
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)callback, (Function)renderer);
        }
    }

    @NotNull
    private static List<GrExpression> collectExpressions(@NotNull PsiElement element) {
        GrBinaryExpression binary;
        assert (element instanceof GrExpression);
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add((GrExpression)element);
        while (element.getParent() instanceof GrBinaryExpression && ConvertStringToMultilineIntention.isAppropriateBinary(binary = (GrBinaryExpression)element.getParent(), element)) {
            result2.add(binary);
            element = binary;
        }
        return result2;
    }

    private static boolean isAppropriateBinary(@NotNull GrBinaryExpression binary, @Nullable PsiElement prevChecked) {
        if (binary.getOperationTokenType() == GroovyTokenTypes.mPLUS) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if ((left != prevChecked || ConvertStringToMultilineIntention.containsOnlyLiterals(right)) && (right != prevChecked || ConvertStringToMultilineIntention.containsOnlyLiterals(left))) {
                return true;
            }
        }
        return false;
    }

    private static boolean containsOnlyLiterals(@Nullable GrExpression expression) {
        if (expression instanceof GrLiteral) {
            String text = expression.getText();
            if ("'".equals(GrStringUtil.getStartQuote(text))) {
                return true;
            }
            if ("\"".equals(GrStringUtil.getStartQuote(text))) {
                return true;
            }
        } else if (expression instanceof GrBinaryExpression) {
            IElementType type2 = ((GrBinaryExpression)expression).getOperationTokenType();
            if (type2 != GroovyTokenTypes.mPLUS) {
                return false;
            }
            GrExpression left = ((GrBinaryExpression)expression).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)expression).getRightOperand();
            return ConvertStringToMultilineIntention.containsOnlyLiterals(left) && ConvertStringToMultilineIntention.containsOnlyLiterals(right);
        }
        return false;
    }

    @NotNull
    private static List<GrLiteral> collectOperands(@Nullable PsiElement element, @NotNull List<GrLiteral> initial) {
        if (element instanceof GrLiteral) {
            initial.add((GrLiteral)element);
        } else if (element instanceof GrBinaryExpression) {
            ConvertStringToMultilineIntention.collectOperands(((GrBinaryExpression)element).getLeftOperand(), initial);
            ConvertStringToMultilineIntention.collectOperands(((GrBinaryExpression)element).getRightOperand(), initial);
        }
        return initial;
    }

    private void invokeImpl(@NotNull GrExpression element, @NotNull Project project, @NotNull Editor editor) {
        List<GrLiteral> literals = ConvertStringToMultilineIntention.collectOperands(element, ContainerUtil.newArrayList());
        if (literals.isEmpty()) {
            return;
        }
        StringBuilder buffer = ConvertStringToMultilineIntention.prepareNewLiteralText(literals);
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                int offset = editor.getCaretModel().getOffset();
                TextRange range = element.getTextRange();
                int shift = editor.getSelectionModel().hasSelection() ? 0 : (range.getStartOffset() == offset ? 0 : (range.getEndOffset() == offset + 1 ? -2 : 2));
                GrExpression newLiteral = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(buffer.toString());
                element.replaceWithExpression(newLiteral, true);
                if (shift != 0) {
                    editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + shift);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), this.getText(), null);
    }

    private static StringBuilder prepareNewLiteralText(List<GrLiteral> literals) {
        String quote = !ConvertStringToMultilineIntention.containsInjections(literals) && literals.get(0).getText().startsWith("'") ? "'''" : "\"\"\"";
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        for (GrLiteral literal : literals) {
            if (literal instanceof GrLiteralImpl) {
                ConvertStringToMultilineIntention.appendSimpleStringValue(literal, buffer, quote);
                continue;
            }
            GrStringImpl gstring = (GrStringImpl)literal;
            for (GroovyPsiElement child : gstring.getAllContentParts()) {
                if (child instanceof GrStringContent) {
                    ConvertStringToMultilineIntention.appendSimpleStringValue(child, buffer, "\"\"\"");
                    continue;
                }
                if (!(child instanceof GrStringInjection)) continue;
                buffer.append(child.getText());
            }
        }
        buffer.append(quote);
        return buffer;
    }

    private static boolean containsInjections(@NotNull List<GrLiteral> literals) {
        for (GrLiteral literal : literals) {
            if (!(literal instanceof GrString) || ((GrString)literal).getInjections().length <= 0) continue;
            return true;
        }
        return false;
    }

    private static void appendSimpleStringValue(PsiElement element, StringBuilder buffer, String quote) {
        String text = GrStringUtil.removeQuotes(element.getText());
        int position = buffer.length();
        if ("'''".equals(quote)) {
            GrStringUtil.escapeAndUnescapeSymbols(text, "", "'n", buffer);
            GrStringUtil.fixAllTripleQuotes(buffer, position);
        } else {
            GrStringUtil.escapeAndUnescapeSymbols(text, "", "\"n", buffer);
            GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                return element instanceof GrLiteral && ("\"".equals(GrStringUtil.getStartQuote(element.getText())) || "'".equals(GrStringUtil.getStartQuote(element.getText()))) || element instanceof GrBinaryExpression && ConvertStringToMultilineIntention.isAppropriateBinary((GrBinaryExpression)element, null);
            }
        };
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return file;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

