/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

public class ReplaceAbstractClassInstanceByMapIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement psiElement, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        GrCodeReferenceElement ref = (GrCodeReferenceElement)psiElement;
        GrAnonymousClassDefinition anonymous = (GrAnonymousClassDefinition)ref.getParent();
        GrNewExpression newExpr = (GrNewExpression)anonymous.getParent();
        PsiElement resolved = ref.resolve();
        assert (resolved instanceof PsiClass);
        GrTypeDefinitionBody body = anonymous.getBody();
        assert (body != null);
        ArrayList<Pair> methods = new ArrayList<Pair>();
        for (GrMethod method : body.getMethods()) {
            methods.add(new Pair((Object)method, (Object)method.getBlock()));
        }
        PsiClass iface = (PsiClass)resolved;
        Collection collection = OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)anonymous, (boolean)true);
        for (CandidateInfo info : collection) {
            methods.add(new Pair((Object)((PsiMethod)info.getElement()), null));
        }
        StringBuilder buffer = new StringBuilder();
        if (methods.size() == 1) {
            Pair pair = (Pair)methods.get(0);
            ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod((PsiMethod)pair.getFirst(), buffer, (GrOpenBlock)pair.getSecond(), newExpr);
            if (!GroovyConfigUtils.getInstance().isVersionAtLeast(psiElement, "2.2")) {
                buffer.append(" as ").append(iface.getQualifiedName());
            }
        } else {
            buffer.append("[");
            buffer.append("\n");
            for (Pair pair : methods) {
                PsiMethod method = (PsiMethod)pair.getFirst();
                GrOpenBlock block = (GrOpenBlock)pair.getSecond();
                buffer.append(method.getName()).append(": ");
                ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod(method, buffer, block, newExpr);
                buffer.append(",\n");
            }
            if (!methods.isEmpty()) {
                buffer.delete(buffer.length() - 2, buffer.length());
                buffer.append('\n');
            }
            buffer.append("]");
            buffer.append(" as ").append(iface.getQualifiedName());
        }
        ReplaceAbstractClassInstanceByMapIntention.createAndAdjustNewExpression(project, newExpr, buffer);
    }

    private static void createAndAdjustNewExpression(Project project, GrNewExpression newExpression, StringBuilder buffer) throws IncorrectOperationException {
        GrExpression expr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(buffer.toString());
        GrExpression safeTypeExpr = newExpression.replaceWithExpression(expr, false);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)safeTypeExpr);
    }

    private static void appendClosureTextByMethod(PsiMethod method, StringBuilder buffer, @Nullable GrOpenBlock block, GroovyPsiElement context) {
        PsiParameterList list = method.getParameterList();
        buffer.append("{ ");
        PsiParameter[] parameters = list.getParameters();
        HashSet<String> generatedNames = new HashSet<String>();
        if (parameters.length > 0) {
            PsiParameter first = parameters[0];
            PsiType type2 = first.getType();
            buffer.append(type2.getCanonicalText()).append(" ");
            buffer.append(ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, first, type2, context));
        }
        for (int i = 1; i < parameters.length; ++i) {
            buffer.append(", ");
            PsiParameter param = parameters[i];
            PsiType type3 = param.getType();
            buffer.append(type3.getCanonicalText()).append(" ");
            String name = ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, param, type3, context);
            buffer.append(name);
        }
        if (parameters.length > 0) {
            buffer.append(" ->");
        }
        if (block != null) {
            PsiElement child;
            PsiElement lBrace = block.getLBrace();
            PsiElement rBrace = block.getRBrace();
            PsiElement psiElement = child = lBrace != null ? lBrace.getNextSibling() : block.getFirstChild();
            while (child != null && child != rBrace) {
                buffer.append(child.getText());
                child = child.getNextSibling();
            }
        }
        buffer.append(" }");
    }

    private static String createName(Set<String> generatedNames, PsiParameter param, PsiType type2, GroovyPsiElement context) {
        String name = param.getName();
        if (name == null) {
            name = GroovyNameSuggestionUtil.suggestVariableNameByType(type2, new DefaultGroovyVariableNameValidator(context, generatedNames))[0];
            assert (name != null);
        }
        generatedNames.add(name);
        return name;
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrAnonymousClassDefinition anonymous;
            return element instanceof GrCodeReferenceElement && element.getParent() instanceof GrAnonymousClassDefinition && (anonymous = (GrAnonymousClassDefinition)element.getParent()).getFields().length == 0;
        }
    }
}

