/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.handlers.GroovyMethodSignatureInsertHandler;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GroovyDocCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static void register(CompletionContributor contributor) {
        GroovyDocCompletionProvider provider2 = new GroovyDocCompletionProvider();
        contributor.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().inside(GrDocTagValueToken.class), (CompletionProvider)provider2);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        GrCodeReferenceElement referenceElement;
        PsiElement position = parameters.getPosition();
        GrDocMemberReference reference = (GrDocMemberReference)PsiTreeUtil.getParentOfType((PsiElement)position, GrDocMemberReference.class);
        if (reference == null) {
            return;
        }
        GrDocReferenceElement holder = reference.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : PsiUtil.getContextClass(reference);
        if (resolved instanceof PsiClass) {
            PsiElement[] elements;
            ResolverProcessor propertyProcessor = CompletionProcessor.createPropertyCompletionProcessor(reference);
            resolved.processDeclarations((PsiScopeProcessor)propertyProcessor, ResolveState.initial(), null, (PsiElement)reference);
            Object[] propertyCandidates = ResolveUtil.mapToElements(propertyProcessor.getCandidates());
            ResolverProcessor methodProcessor = CompletionProcessor.createPropertyCompletionProcessor(reference);
            resolved.processDeclarations((PsiScopeProcessor)methodProcessor, ResolveState.initial(), null, (PsiElement)reference);
            Object[] methodCandidates = ResolveUtil.mapToElements(methodProcessor.getCandidates());
            for (PsiElement psiElement : elements = (PsiElement[])ArrayUtil.mergeArrays((Object[])propertyCandidates, (Object[])methodCandidates)) {
                LookupElement element = GroovyCompletionUtil.createLookupElement((PsiNamedElement)psiElement);
                if (psiElement instanceof PsiMethod) {
                    element = ((LookupElementBuilder)element).withInsertHandler((InsertHandler)new GroovyMethodSignatureInsertHandler());
                }
                result2.addElement(element);
            }
        }
    }
}

