/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrWhileConditionFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (psiElement instanceof GrWhileStatement) {
            Document doc = editor.getDocument();
            GrWhileStatement whileStatement = (GrWhileStatement)psiElement;
            PsiElement rParenth = whileStatement.getRParenth();
            PsiElement lParenth = whileStatement.getLParenth();
            GrExpression condition = whileStatement.getCondition();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(whileStatement.getTextRange().getStartOffset()));
                    GrStatement block = whileStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, whileStatement.getTextRange().getEndOffset());
                    doc.replaceString(whileStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"while ()");
                    processor.registerUnresolvedError(whileStatement.getTextRange().getStartOffset() + "while (".length());
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

