/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrDocMethodParamsImpl
extends GroovyDocPsiElementImpl
implements GrDocMethodParams {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMethodParamsImpl");

    public GrDocMethodParamsImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "GrDocMethodParameterList";
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitDocMethodParameterList(this);
    }

    @Override
    public PsiType[] getParameterTypes() {
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        PsiManagerEx manager = this.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.getProject());
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        for (GrDocMethodParameter parameter : this.getParameters()) {
            GrDocReferenceElement typeElement = parameter.getTypeElement();
            try {
                PsiType type2 = factory.createTypeFromText(typeElement.getText(), (PsiElement)this);
                type2 = TypesUtil.boxPrimitiveType(type2, (PsiManager)manager, scope);
                types.add(type2);
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                types.add(null);
            }
        }
        return types.toArray(PsiType.createArray((int)types.size()));
    }

    @Override
    public GrDocMethodParameter[] getParameters() {
        ArrayList<GrDocMethodParameter> result2 = new ArrayList<GrDocMethodParameter>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrDocMethodParameter)) continue;
            result2.add((GrDocMethodParameter)cur);
        }
        return result2.toArray(new GrDocMethodParameter[0]);
    }

    @Override
    @NotNull
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN);
        assert (paren != null);
        return paren.getPsi();
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN);
        return paren != null ? paren.getPsi() : null;
    }
}

