/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class GrDocTagImpl
extends GroovyDocPsiElementImpl
implements GrDocTag {
    private static final TokenSet VALUE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN, GroovyDocElementTypes.GDOC_METHOD_REF, GroovyDocElementTypes.GDOC_FIELD_REF, GroovyDocElementTypes.GDOC_PARAM_REF, GroovyDocElementTypes.GDOC_REFERENCE_ELEMENT, GroovyDocTokenTypes.mGDOC_COMMENT_DATA, GroovyDocElementTypes.GDOC_INLINED_TAG});

    public GrDocTagImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitDocTag(this);
    }

    public String toString() {
        return "GroovyDocTag";
    }

    @NotNull
    public String getName() {
        return this.getNameElement().getText().substring(1);
    }

    @NotNull
    public PsiElement getNameElement() {
        PsiElement element = this.findChildByType(GroovyDocTokenTypes.mGDOC_TAG_NAME);
        assert (element != null);
        return element;
    }

    @Override
    public GrDocComment getContainingComment() {
        return (GrDocComment)this.getParent();
    }

    @Override
    @Nullable
    public GrDocTagValueToken getValueElement() {
        return (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
    }

    @Override
    @Nullable
    public GrDocParameterReference getDocParameterReference() {
        return (GrDocParameterReference)this.findChildByClass(GrDocParameterReference.class);
    }

    @NotNull
    public PsiElement[] getDataElements() {
        List list = this.findChildrenByType(VALUE_BIT_SET);
        return PsiUtilCore.toPsiElementArray((Collection)list);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement nameElement = this.getNameElement();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrDocComment comment = factory.createDocCommentFromText("/** @" + name + "*/");
        nameElement.replace(comment.getTags()[0].getNameElement());
        return this;
    }
}

