/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class GroovyAnnotationAttributeInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrAnnotationArgumentList, PsiAnnotationMethod, GrAnnotationNameValuePair> {
    private static final Set<Class> ALLOWED_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrAnnotation.class});
    private static final Set<Class> STOP_SEARCHING_CLASSES = Collections.singleton(GroovyFile.class);

    @NotNull
    public GrAnnotationNameValuePair[] getActualParameters(@NotNull GrAnnotationArgumentList o) {
        return o.getAttributes();
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        return GroovyTokenTypes.mCOMMA;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        return GroovyTokenTypes.mRPAREN;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        return ALLOWED_CLASSES;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        return STOP_SEARCHING_CLASSES;
    }

    @NotNull
    public Class<GrAnnotationArgumentList> getArgumentListClass() {
        return GrAnnotationArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (item == null || context == null) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof GroovyResolveResult) {
            o = ((GroovyResolveResult)o).getElement();
        }
        if (o instanceof PsiClass && ((PsiClass)o).isAnnotationType()) {
            return GroovyAnnotationAttributeInfoHandler.extractAnnotationMethodsFromClass((PsiClass)o);
        }
        return GrAnnotationNameValuePair.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiAnnotationMethod[] extractAnnotationMethodsFromClass(@NotNull PsiClass o) {
        Object[] methods;
        if (o.isAnnotationType() && (methods = o.getMethods()).length > 0) {
            List annotationMethods = ContainerUtil.findAll((Object[])methods, PsiAnnotationMethod.class);
            return annotationMethods.toArray(PsiAnnotationMethod.EMPTY_ARRAY);
        }
        return PsiAnnotationMethod.EMPTY_ARRAY;
    }

    public GrAnnotationArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    @Nullable
    private static GrAnnotationArgumentList findAnchor(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        return (GrAnnotationArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, GrAnnotationArgumentList.class);
    }

    public void showParameterInfo(@NotNull GrAnnotationArgumentList argumentList, @NotNull CreateParameterInfoContext context) {
        GrAnnotation parent2 = (GrAnnotation)argumentList.getParent();
        PsiElement resolved = parent2.getClassReference().resolve();
        if (resolved instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            Object[] methods = GroovyAnnotationAttributeInfoHandler.extractAnnotationMethodsFromClass((PsiClass)resolved);
            context.setItemsToShow(methods);
            context.showHint((PsiElement)argumentList, argumentList.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
            PsiAnnotationMethod currentMethod = GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor());
            if (currentMethod != null) {
                context.setHighlightedElement((PsiElement)currentMethod);
            }
        }
    }

    @Nullable
    private static PsiAnnotationMethod findAnnotationMethod(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiNameValuePair pair = (PsiNameValuePair)ParameterInfoUtils.findParentOfType((PsiFile)file, (int)GroovyAnnotationAttributeInfoHandler.inferOffset(editor), PsiNameValuePair.class);
        if (pair == null) {
            return null;
        }
        PsiReference reference = pair.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        return PsiUtil.isAnnotationMethod((PsiElement)resolved) ? (PsiAnnotationMethod)resolved : null;
    }

    public GrAnnotationArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    public void updateParameterInfo(@NotNull GrAnnotationArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        context.setHighlightedParameter((Object)GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor()));
    }

    private static int inferOffset(@NotNull Editor editor) {
        int offset1;
        CharSequence chars = editor.getDocument().getCharsSequence();
        char character = chars.charAt(offset1 = CharArrayUtil.shiftForward((CharSequence)chars, (int)editor.getCaretModel().getOffset(), (String)" \t"));
        if (character == ',' || character == ')') {
            offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset1 - 1), (String)" \t");
        }
        return offset1;
    }

    public void updateUI(@NotNull PsiAnnotationMethod p, @NotNull ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        PsiType returnType2 = p.getReturnType();
        assert (returnType2 != null);
        buffer.append(returnType2.getPresentableText());
        buffer.append(" ");
        int highlightStartOffset = buffer.length();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append("()");
        PsiAnnotationMemberValue defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            buffer.append(" default ");
            buffer.append(defaultValue.getText());
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, p.isDeprecated(), false, context.getDefaultParameterColor());
    }
}

