/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GroovyPsiElement, Object, GroovyPsiElement> {
    private static final Logger LOG = Logger.getInstance(GroovyParameterInfoHandler.class);
    private static final Set<Class> ourStopSearch = Collections.singleton(GrMethod.class);
    private static final Set<Class> ALLOWED_PARAM_CLASSES = Collections.singleton(GroovyPsiElement.class);

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        return ourStopSearch;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List elements = JavaCompletionUtil.getAllPsiElements((LookupElement)item);
        if (elements != null) {
            ArrayList<ElementResolveResult<PsiElement>> methods = new ArrayList<ElementResolveResult<PsiElement>>();
            for (PsiElement element : elements) {
                if (!(element instanceof PsiMethod)) continue;
                methods.add(new ElementResolveResult<PsiElement>(element));
            }
            return ArrayUtil.toObjectArray(methods);
        }
        return null;
    }

    public GroovyPsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        return GroovyParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public GroovyPsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        return GroovyParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    @Nullable
    private static GroovyPsiElement findAnchorElement(int offset, PsiFile file) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        GroovyPsiElement argList = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, GrArgumentList.class);
        if (argList != null) {
            return argList;
        }
        GrCall call = (GrCall)PsiTreeUtil.getParentOfType((PsiElement)element, GrCall.class);
        if (call != null) {
            argList = call.getArgumentList();
            if (argList != null && argList.getTextRange().contains(element.getTextRange().getStartOffset())) {
                return argList;
            }
        } else {
            offset = CharArrayUtil.shiftBackward((CharSequence)file.getText(), (int)offset, (String)"\n\t ");
            if (offset <= 0) {
                return null;
            }
            element = file.findElementAt(offset);
            if (element != null && element.getParent() instanceof GrReferenceExpression) {
                return (GroovyPsiElement)element.getParent();
            }
        }
        return null;
    }

    public void showParameterInfo(@NotNull GroovyPsiElement place, @NotNull CreateParameterInfoContext context) {
        GroovyResolveResult[] variants = ResolveUtil.getCallVariants(place);
        ArrayList<Object> elementToShow = new ArrayList<Object>();
        PsiElement parent2 = place.getParent();
        if (parent2 instanceof GrMethodCall) {
            GrExpression invoked = ((GrMethodCall)parent2).getInvokedExpression();
            if (GroovyParameterInfoHandler.isPropertyOrVariableInvoked(invoked)) {
                PsiType type2 = invoked.getType();
                if (type2 instanceof GrClosureType) {
                    GroovyParameterInfoHandler.addSignatureVariant(elementToShow, (GrClosureType)type2);
                } else if (type2 != null) {
                    GroovyParameterInfoHandler.addMethodAndClosureVariants(elementToShow, ResolveUtil.getMethodCandidates(type2, "call", (PsiElement)invoked, PsiUtil.getArgumentTypes(place, true)));
                }
            } else {
                GroovyParameterInfoHandler.addMethodAndClosureVariants(elementToShow, variants);
            }
        } else {
            elementToShow.addAll(Arrays.asList(variants));
        }
        GroovyParameterInfoHandler.filterOutReflectedMethods(elementToShow);
        context.setItemsToShow(ArrayUtil.toObjectArray(elementToShow));
        context.showHint((PsiElement)place, place.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    private static void addMethodAndClosureVariants(@NotNull List<Object> elementToShow, @NotNull GroovyResolveResult[] variants) {
        for (GroovyResolveResult variant : variants) {
            PsiType type2;
            PsiElement element = variant.getElement();
            if (element instanceof PsiMethod) {
                elementToShow.add(variant);
                continue;
            }
            if (!(element instanceof GrVariable) || !((type2 = ((GrVariable)element).getTypeGroovy()) instanceof GrClosureType)) continue;
            GroovyParameterInfoHandler.addSignatureVariant(elementToShow, (GrClosureType)type2);
        }
    }

    private static void addSignatureVariant(@NotNull List<Object> elementToShow, @NotNull GrClosureType type2) {
        elementToShow.addAll(type2.getSignatures());
    }

    private static void filterOutReflectedMethods(List toShow) {
        HashSet methods = new HashSet();
        Iterator iterator2 = toShow.iterator();
        while (iterator2.hasNext()) {
            GrMethod base;
            PsiElement element;
            Object next = iterator2.next();
            if (!(next instanceof GroovyResolveResult) || !((element = ((GroovyResolveResult)next).getElement()) instanceof GrReflectedMethod) || methods.add(base = ((GrReflectedMethod)element).getBaseMethod())) continue;
            iterator2.remove();
        }
    }

    private static boolean isPropertyOrVariableInvoked(GrExpression invoked) {
        if (!(invoked instanceof GrReferenceExpression)) {
            return false;
        }
        GroovyResolveResult resolveResult2 = ((GrReferenceExpression)invoked).advancedResolve();
        return resolveResult2.isInvokedOnProperty() || resolveResult2.getElement() instanceof PsiVariable;
    }

    public void updateParameterInfo(@NotNull GroovyPsiElement place, @NotNull UpdateParameterInfoContext context) {
        PsiElement parameterOwner = context.getParameterOwner();
        if (parameterOwner != place) {
            context.removeHint();
            return;
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        offset = CharArrayUtil.shiftForward((CharSequence)context.getEditor().getDocument().getText(), (int)offset, (String)" \t\n");
        int currIndex = GroovyParameterInfoHandler.getCurrentParameterIndex(place, offset);
        context.setCurrentParameter(currIndex);
        Object[] objects = context.getObjectsToView();
        block0: for (int i = 0; i < objects.length; ++i) {
            PsiType[] parameterTypes = null;
            PsiType[] argTypes = null;
            PsiSubstitutor substitutor = null;
            if (objects[i] instanceof GroovyResolveResult) {
                GroovyResolveResult resolveResult2 = (GroovyResolveResult)objects[i];
                Object namedElement = (PsiNamedElement)resolveResult2.getElement();
                if (namedElement instanceof GrReflectedMethod) {
                    namedElement = ((GrReflectedMethod)namedElement).getBaseMethod();
                }
                substitutor = resolveResult2.getSubstitutor();
                assert (namedElement != null);
                if (!namedElement.isValid()) {
                    context.setUIComponentEnabled(i, false);
                    continue;
                }
                if (namedElement instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)namedElement;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    parameters = GroovyParameterInfoHandler.updateConstructorParams(method, parameters, context.getParameterOwner());
                    parameterTypes = PsiType.createArray((int)parameters.length);
                    for (int j = 0; j < parameters.length; ++j) {
                        parameterTypes[j] = parameters[j].getType();
                    }
                    argTypes = PsiUtil.getArgumentTypes(place, false);
                }
                if (argTypes == null) {
                    continue;
                }
            } else {
                if (!(objects[i] instanceof GrSignature)) continue;
                GrSignature signature = (GrSignature)objects[i];
                argTypes = PsiUtil.getArgumentTypes(place, false);
                parameterTypes = PsiType.createArray((int)signature.getParameterCount());
                int j = 0;
                for (PsiMethod parameter : signature.getParameters()) {
                    parameterTypes[j++] = parameter.getType();
                }
            }
            assert (argTypes != null);
            if (argTypes.length > currIndex) {
                if (parameterTypes.length <= currIndex) {
                    context.setUIComponentEnabled(i, false);
                    continue;
                }
                for (int j = 0; j < currIndex; ++j) {
                    PsiType paramType;
                    PsiType argType = argTypes[j];
                    PsiType psiType = paramType = substitutor != null ? substitutor.substitute(parameterTypes[j]) : parameterTypes[j];
                    if (TypesUtil.isAssignableByMethodCallConversion(paramType, argType, place)) continue;
                    context.setUIComponentEnabled(i, false);
                    break block0;
                }
            }
            context.setUIComponentEnabled(i, true);
        }
    }

    private static int getCurrentParameterIndex(GroovyPsiElement place, int offset) {
        if (place instanceof GrArgumentList) {
            GrArgumentList list = (GrArgumentList)place;
            int idx = list.getNamedArguments().length > 0 ? 1 : 0;
            for (PsiElement child = list.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getTextRange().contains(offset)) {
                    if (child instanceof GrNamedArgument) {
                        return 0;
                    }
                    return idx;
                }
                if (child.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                    ++idx;
                }
                if (!GroovyParameterInfoHandler.isNamedArgWithPriorComma(child)) continue;
                --idx;
            }
        }
        return -1;
    }

    private static boolean isNamedArgWithPriorComma(PsiElement child) {
        if (!(child instanceof GrNamedArgument)) {
            return false;
        }
        PsiElement element = PsiUtil.skipWhitespacesAndComments(child.getPrevSibling(), false);
        return element != null && element.getNode().getElementType() == GroovyTokenTypes.mCOMMA;
    }

    public void updateUI(Object o, @NotNull ParameterInfoUIContext context) {
        Object element;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (o == null) {
            return;
        }
        if (o instanceof GroovyResolveResult) {
            element = ((GroovyResolveResult)o).getElement();
            if (element == null || !element.isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
        } else if (o instanceof GrSignature) {
            if (!((GrSignature)o).isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
            element = o;
        } else {
            return;
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        int currentParameter = context.getCurrentParameterIndex();
        StringBuilder buffer = new StringBuilder();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method instanceof GrReflectedMethod) {
                method = ((GrReflectedMethod)method).getBaseMethod();
            }
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                PsiType returnType2;
                if (!method.isConstructor() && (returnType2 = PsiUtil.getSmartReturnType(method)) != null) {
                    buffer.append(returnType2.getPresentableText());
                    buffer.append(' ');
                }
                buffer.append(method.getName());
                buffer.append('(');
            }
            PsiParameter[] params = method.getParameterList().getParameters();
            int numParams = (params = GroovyParameterInfoHandler.updateConstructorParams(method, params, context.getParameterOwner())).length;
            if (numParams > 0) {
                LOG.assertTrue(o instanceof GroovyResolveResult, o.getClass());
                PsiSubstitutor substitutor = ((GroovyResolveResult)o).getSubstitutor();
                for (int j = 0; j < numParams; ++j) {
                    PsiParameter param = params[j];
                    int startOffset = buffer.length();
                    GroovyParameterInfoHandler.appendParameterText(param, substitutor, buffer);
                    int endOffset = buffer.length();
                    if (j < numParams - 1) {
                        buffer.append(", ");
                    }
                    if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !param.isVarArgs() || currentParameter < numParams)) continue;
                    highlightStartOffset = startOffset;
                    highlightEndOffset = endOffset;
                }
            } else {
                buffer.append("no parameters");
            }
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(")");
            }
        } else if (element instanceof PsiClass) {
            buffer.append("no parameters");
        } else if (element instanceof GrSignature) {
            GrClosureParameter[] parameters = ((GrSignature)element).getParameters();
            if (parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    GrExpression initializer;
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    int startOffset = buffer.length();
                    PsiType psiType = parameters[i].getType();
                    if (psiType == null) {
                        buffer.append("def");
                    } else {
                        buffer.append(psiType.getPresentableText());
                    }
                    buffer.append(' ').append(parameters[i].getName() != null ? parameters[i].getName() : "<unknown>");
                    int endOffset = buffer.length();
                    if (context.isUIComponentEnabled() && (i == currentParameter || i == parameters.length - 1 && ((GrSignature)element).isVarargs() && currentParameter >= parameters.length)) {
                        highlightStartOffset = startOffset;
                        highlightEndOffset = endOffset;
                    }
                    if ((initializer = parameters[i].getDefaultInitializer()) == null) continue;
                    buffer.append(" = ").append(initializer.getText());
                }
            } else {
                buffer.append("no parameters");
            }
        }
        boolean isDeprecated = o instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)o).isDeprecated();
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), isDeprecated, false, context.getDefaultParameterColor());
    }

    private static PsiParameter[] updateConstructorParams(PsiMethod method, PsiParameter[] params, PsiElement place) {
        if (GrInnerClassConstructorUtil.isInnerClassConstructorUsedOutsideOfItParent(method, place)) {
            GrMethod grMethod = (GrMethod)method;
            params = GrInnerClassConstructorUtil.addEnclosingInstanceParam(grMethod, method.getContainingClass().getContainingClass(), grMethod.getParameters(), true);
        }
        return params;
    }

    private static void appendParameterText(PsiParameter param, PsiSubstitutor substitutor, StringBuilder buffer) {
        if (param instanceof GrParameter) {
            GrParameter grParam = (GrParameter)param;
            GroovyPresentationUtil.appendParameterPresentation(grParam, substitutor, TypePresentation.PRESENTABLE, buffer);
            GrExpression initializer = grParam.getInitializerGroovy();
            if (initializer != null) {
                buffer.append(" = ").append(initializer.getText());
            } else if (grParam.isOptional()) {
                buffer.append(" = null");
            }
        } else {
            PsiType t = param.getType();
            PsiType paramType = substitutor.substitute(t);
            buffer.append(paramType.getPresentableText());
            String name = param.getName();
            if (name != null) {
                buffer.append(" ");
                buffer.append(name);
            }
        }
    }

    @NotNull
    public GroovyPsiElement[] getActualParameters(@NotNull GroovyPsiElement o) {
        if (o instanceof GrArgumentList) {
            return ((GrArgumentList)o).getAllArguments();
        }
        return GroovyPsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        return GroovyTokenTypes.mCOMMA;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        return GroovyTokenTypes.mRPAREN;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        return ALLOWED_PARAM_CLASSES;
    }

    @NotNull
    public Class<GroovyPsiElement> getArgumentListClass() {
        return GroovyPsiElement.class;
    }
}

