/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.api;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

public interface GroovyReference
extends PsiPolyVariantReference {
    public static final GroovyReference[] EMPTY_ARRAY = new GroovyReference[0];

    @Nullable
    default public PsiElement resolve() {
        return this.advancedResolve().getElement();
    }

    @NotNull
    default public GroovyResolveResult advancedResolve() {
        Collection<? extends GroovyResolveResult> results = this.resolve(false);
        if (results.size() == 1) {
            return (GroovyResolveResult)ContainerUtil.getFirstItem(results);
        }
        return EmptyGroovyResolveResult.INSTANCE;
    }

    @NotNull
    default public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return this.resolve(incompleteCode).toArray(GroovyResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    default public Collection<? extends GroovyResolveResult> resolve(boolean incomplete) {
        return Arrays.asList(this.multiResolve(incomplete));
    }
}

