/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class InstanceOfInstruction
extends InstructionImpl
implements MixinTypeInstruction {
    private final ConditionInstruction myCondition;

    public InstanceOfInstruction(@NotNull GrExpression assertion, ConditionInstruction cond) {
        super(assertion);
        this.myCondition = cond;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        return Objects.requireNonNull(super.getElement());
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        return "instanceof: " + this.getElement().getText();
    }

    @Nullable
    private Pair<GrExpression, PsiType> getInstanceof() {
        PsiElement element = this.getElement();
        if (element instanceof GrInstanceOfExpression) {
            GrExpression operand = ((GrInstanceOfExpression)element).getOperand();
            GrTypeElement typeElement = ((GrInstanceOfExpression)element).getTypeElement();
            if (operand instanceof GrReferenceExpression && ((GrReferenceExpression)operand).getQualifier() == null && typeElement != null) {
                return Pair.create((Object)((GrInstanceOfExpression)element).getOperand(), (Object)typeElement.getType());
            }
        } else if (element instanceof GrBinaryExpression && ControlFlowBuilderUtil.isInstanceOfBinary((GrBinaryExpression)element)) {
            GrExpression left = ((GrBinaryExpression)element).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)element).getRightOperand();
            if (right == null) {
                return null;
            }
            GroovyResolveResult result2 = ((GrReferenceExpression)right).advancedResolve();
            PsiElement resolved = result2.getElement();
            if (resolved instanceof PsiClass) {
                PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)element.getProject()).createType((PsiClass)resolved, result2.getSubstitutor());
                return new Pair((Object)left, (Object)type2);
            }
        } else if (element instanceof GrBinaryExpression) {
            GrExpression left = ((GrBinaryExpression)element).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)element).getRightOperand();
            if (PsiUtilKt.isNullLiteral(right)) {
                return Pair.create((Object)left, (Object)PsiType.NULL);
            }
            if (right != null && PsiUtilKt.isNullLiteral(left)) {
                return Pair.create((Object)right, (Object)PsiType.NULL);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType inferMixinType() {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null) {
            return null;
        }
        return (PsiType)instanceOf.getSecond();
    }

    @Override
    @Nullable
    public ReadWriteVariableInstruction getInstructionToMixin(Instruction[] flow) {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null) {
            return null;
        }
        Instruction instruction = ControlFlowUtils.findInstruction((PsiElement)instanceOf.getFirst(), flow);
        if (instruction instanceof ReadWriteVariableInstruction) {
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Override
    @Nullable
    public VariableDescriptor getVariableDescriptor() {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null || !(instanceOf.first instanceof GrReferenceExpression)) {
            return null;
        }
        return VariableDescriptorFactory.createDescriptor((GrReferenceExpression)instanceOf.first);
    }

    @Override
    @Nullable
    public ConditionInstruction getConditionInstruction() {
        return this.myCondition;
    }
}

