/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkCounter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkList;

public class DFAEngine<E> {
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;
    private WorkCounter myCounter = null;

    public DFAEngine(@NotNull Instruction[] flow, @NotNull DfaInstance<E> dfa, @NotNull Semilattice<E> semilattice) {
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    @NotNull
    public List<E> performForceDFA() {
        List<E> result2 = this.performDFA(false);
        assert (result2 != null);
        return result2;
    }

    @Nullable
    public List<E> performDFAWithTimeout() {
        return this.performDFA(true);
    }

    @Nullable
    private List<E> performDFA(boolean timeout) {
        int n = this.myFlow.length;
        ArrayList<E> info = new ArrayList<E>(Collections.nCopies(n, this.myDfa.initial()));
        MyCallEnvironment env = new MyCallEnvironment(n);
        WorkList workList = new WorkList(n, this.getFlowOrder());
        while (!workList.isEmpty()) {
            ProgressManager.checkCanceled();
            if (timeout && this.checkCounter()) {
                return null;
            }
            int num = workList.next();
            Instruction curr = this.myFlow[num];
            Object oldE = info.get(num);
            E newE = this.getInboundState(curr, info, env);
            this.myDfa.fun(newE, curr);
            if (this.mySemilattice.eq(newE, oldE)) continue;
            info.set(num, newE);
            for (Instruction next : this.getNext(curr, env)) {
                workList.offer(next.num());
            }
        }
        return info;
    }

    @NotNull
    private int[] getFlowOrder() {
        if (this.myDfa.isForward()) {
            return OrderUtil.reversedPostOrder(this.myFlow, this.myDfa.isReachable());
        }
        return OrderUtil.postOrder(this.myFlow, this.myDfa.isReachable());
    }

    @NotNull
    private E getInboundState(@NotNull Instruction instruction, @NotNull List<E> info, @NotNull CallEnvironment env) {
        ArrayList<E> prevInfos = new ArrayList<E>();
        for (Instruction i : this.getPrevious(instruction, env)) {
            prevInfos.add(info.get(i.num()));
        }
        return this.mySemilattice.join(prevInfos);
    }

    @NotNull
    private Iterable<Instruction> getPrevious(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        return this.myDfa.isForward() ? instruction.predecessors(env) : instruction.successors(env);
    }

    @NotNull
    private Iterable<Instruction> getNext(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        return this.myDfa.isForward() ? instruction.successors(env) : instruction.predecessors(env);
    }

    private boolean checkCounter() {
        if (this.myCounter == null) {
            this.myCounter = new WorkCounter();
            return false;
        }
        return this.myCounter.isTimeOver();
    }

    private static class MyCallEnvironment
    implements CallEnvironment {
        ArrayList<Deque<CallInstruction>> myEnv;

        private MyCallEnvironment(int instructionNum) {
            this.myEnv = new ArrayList(instructionNum);
            for (int i = 0; i < instructionNum; ++i) {
                this.myEnv.add(new ArrayDeque());
            }
        }

        @Override
        @NotNull
        public Deque<CallInstruction> callStack(@NotNull Instruction instruction) {
            return this.myEnv.get(instruction.num());
        }

        @Override
        public void update(@NotNull Deque<CallInstruction> callStack, @NotNull Instruction instruction) {
            this.myEnv.set(instruction.num(), callStack);
        }
    }
}

