/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class DFAType {
    private final PsiType primary;
    private final List<Mixin> mixins = new ArrayList<Mixin>();

    private DFAType(@Nullable PsiType primary) {
        this.primary = primary;
    }

    public void addMixin(@Nullable PsiType mixin, @Nullable ConditionInstruction instruction) {
        if (mixin == null) {
            return;
        }
        this.mixins.add(new Mixin(mixin, instruction, instruction != null && instruction.isNegated()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAType)) {
            return false;
        }
        DFAType other = (DFAType)obj;
        if (!DFAType.eq(this.primary, other.primary)) {
            return false;
        }
        if (this.mixins.size() != other.mixins.size()) {
            return false;
        }
        for (Mixin mixin1 : this.mixins) {
            boolean contains = false;
            for (Mixin mixin2 : other.mixins) {
                if (!mixin1.equals(mixin2)) continue;
                contains = mixin1.myNegated == mixin2.myNegated;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Contract(value="-> new")
    @NotNull
    public DFAType copy() {
        DFAType type2 = new DFAType(this.primary);
        type2.mixins.addAll(this.mixins);
        return type2;
    }

    @Contract(value="_ -> new")
    @NotNull
    public DFAType negate(@NotNull NegatingGotoInstruction negation) {
        DFAType result2 = this.copy();
        Set<ConditionInstruction> conditionsToNegate = negation.getCondition().getDependentConditions();
        ListIterator<Mixin> iterator2 = result2.mixins.listIterator();
        while (iterator2.hasNext()) {
            Mixin mixin = iterator2.next();
            if (!conditionsToNegate.contains(mixin.myCondition)) continue;
            iterator2.set(mixin.negate());
        }
        return result2;
    }

    @Nullable
    public PsiType getResultType() {
        if (this.mixins.isEmpty()) {
            return this.primary;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        if (this.primary != null) {
            types.add(this.primary);
        }
        for (Mixin mixin : this.mixins) {
            if (mixin.myNegated || mixin.myType.equals(PsiType.NULL)) continue;
            types.add(mixin.myType);
        }
        if (types.isEmpty()) {
            return null;
        }
        return PsiIntersectionType.createIntersection((PsiType[])types.toArray(PsiType.createArray((int)types.size())));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static DFAType create(@Nullable PsiType type2) {
        return new DFAType(type2);
    }

    private static boolean eq(PsiType t1, PsiType t2) {
        return t1 == t2 || Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)t1), (Object)TypeConversionUtil.erasure((PsiType)t2));
    }

    @NotNull
    public static DFAType create(DFAType t1, DFAType t2, PsiManager manager) {
        if (t1.equals(t2)) {
            return t1;
        }
        PsiType primary = TypesUtil.getLeastUpperBoundNullable(t1.primary, t2.primary, manager);
        DFAType type2 = new DFAType(primary);
        PsiType type1 = DFAType.reduce(t1.mixins);
        PsiType type22 = DFAType.reduce(t2.mixins);
        if (type1 != null && type22 != null) {
            type2.addMixin(GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type22, (PsiManager)manager), null);
        }
        return type2;
    }

    private static PsiType reduce(List<Mixin> mixins) {
        List types = mixins.stream().filter(it -> !((Mixin)it).myNegated).map(it -> ((Mixin)it).myType).collect(Collectors.toList());
        return types.isEmpty() ? null : PsiIntersectionType.createIntersection(types);
    }

    public String toString() {
        return "{" + this.primary + " : " + this.mixins + "}";
    }

    private static class Mixin {
        @NotNull
        private final PsiType myType;
        @Nullable
        private final ConditionInstruction myCondition;
        private final boolean myNegated;

        private Mixin(@NotNull PsiType type2, @Nullable ConditionInstruction condition, boolean negated) {
            this.myType = type2;
            this.myCondition = condition;
            this.myNegated = negated;
        }

        private Mixin negate() {
            return new Mixin(this.myType, this.myCondition, !this.myNegated);
        }

        public String toString() {
            return (this.myNegated ? "!" : "") + this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mixin mixin = (Mixin)o;
            if (!this.myType.equals(mixin.myType)) {
                return false;
            }
            return Objects.equals(this.myCondition, mixin.myCondition);
        }

        public int hashCode() {
            int result2 = this.myType.hashCode();
            result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
            return result2;
        }
    }
}

