/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;

public class ReachingDefinitionsDfaInstance
implements DfaInstance<DefinitionMap> {
    protected final TObjectIntHashMap<VariableDescriptor> myVarToIndexMap;
    private final Instruction[] myFlow;

    public ReachingDefinitionsDfaInstance(@NotNull Instruction[] flow, @NotNull TObjectIntHashMap<VariableDescriptor> varIndexes) {
        this.myVarToIndexMap = varIndexes;
        this.myFlow = flow;
    }

    @Override
    public void fun(@NotNull DefinitionMap m, @NotNull Instruction instruction) {
        if (instruction instanceof ReadWriteVariableInstruction) {
            ReadWriteVariableInstruction varInsn = (ReadWriteVariableInstruction)instruction;
            VariableDescriptor descriptor2 = varInsn.getDescriptor();
            assert (this.myVarToIndexMap.containsKey((Object)descriptor2)) : descriptor2 + "; " + Arrays.asList(this.myFlow).contains(instruction);
            int num = this.myVarToIndexMap.get((Object)descriptor2);
            if (varInsn.isWrite()) {
                m.registerDef(varInsn, num);
            }
        }
    }

    @Override
    @NotNull
    public DefinitionMap initial() {
        return new DefinitionMap();
    }
}

