/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.GraphKt;

class InferenceCache {
    private final GrControlFlowOwner myScope;
    private final Instruction[] myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final TObjectIntHashMap<VariableDescriptor> myVarIndexes;
    private final List<DefinitionMap> myDefinitions;
    private final AtomicReference<List<TypeDfaState>> myVarTypes;
    private final Set<Instruction> myTooComplexInstructions = ContainerUtil.newConcurrentSet();

    InferenceCache(@NotNull GrControlFlowOwner scope, @NotNull TObjectIntHashMap<VariableDescriptor> varIndexes, @NotNull List<DefinitionMap> definitions) {
        this.myScope = scope;
        this.myFlow = scope.getControlFlow();
        this.myVarIndexes = varIndexes;
        this.myDefinitions = definitions;
        this.myFromByElements = Arrays.stream(this.myFlow).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
        for (int i = 0; i < this.myFlow.length; ++i) {
            noTypes.add(new TypeDfaState());
        }
        this.myVarTypes = new AtomicReference(noTypes);
    }

    @Nullable
    PsiType getInferredType(@NotNull VariableDescriptor descriptor2, @NotNull Instruction instruction, boolean mixinOnly) {
        DFAType dfaType;
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        TypeDfaState cache2 = this.myVarTypes.get().get(instruction.num());
        if (!cache2.containsVariable(descriptor2)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            Couple<Set<Instruction>> interesting = this.collectRequiredInstructions(instruction, descriptor2, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, interesting);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll((Collection)interesting.first);
            } else {
                this.cacheDfaResult(dfaResult);
            }
        }
        return (dfaType = this.getCachedInferredType(descriptor2, instruction)) == null ? null : dfaType.getResultType();
    }

    @Nullable
    private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, @NotNull Instruction[] flow, @NotNull Couple<Set<Instruction>> interesting) {
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, interesting, this);
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
    }

    @Nullable
    DFAType getCachedInferredType(@NotNull VariableDescriptor descriptor2, @NotNull Instruction instruction) {
        return this.myVarTypes.get().get(instruction.num()).getVariableType(descriptor2);
    }

    private Couple<Set<Instruction>> collectRequiredInstructions(@NotNull Instruction instruction, @NotNull VariableDescriptor descriptor2, @NotNull Predicate<? super Instruction> predicate2) {
        LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>>();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(Pair.create((Object)instruction, (Object)descriptor2));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, VariableDescriptor>> dependencies = this.findDependencies((Instruction)pair.first, (VariableDescriptor)pair.second);
            interesting.put(pair, dependencies);
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        return Couple.of(interestingInstructions, acyclicInstructions);
    }

    @NotNull
    private Set<Pair<Instruction, VariableDescriptor>> findDependencies(@NotNull Instruction instruction, @NotNull VariableDescriptor descriptor2) {
        int varIndex;
        DefinitionMap definitionMap = this.myDefinitions.get(instruction.num());
        int[] definitions = definitionMap.getDefinitions(varIndex = this.myVarIndexes.get((Object)descriptor2));
        if (definitions == null) {
            return Collections.emptySet();
        }
        LinkedHashSet pairs = ContainerUtil.newLinkedHashSet();
        for (int defIndex : definitions) {
            Instruction write = this.myFlow[defIndex];
            pairs.add(Pair.create((Object)write, (Object)descriptor2));
            PsiElement statement = InferenceCache.findDependencyScope(write.getElement());
            if (statement == null) continue;
            pairs.addAll(this.findAllInstructionsInside(statement));
        }
        return pairs;
    }

    @NotNull
    private List<Pair<Instruction, VariableDescriptor>> findAllInstructionsInside(@NotNull PsiElement scope) {
        final ArrayList result2 = ContainerUtil.newArrayList();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified()) {
                    VariableDescriptor descriptor2 = VariableDescriptorFactory.createDescriptor((GrReferenceExpression)element);
                    List instructionList = (List)InferenceCache.this.myFromByElements.get(element);
                    if (descriptor2 != null && instructionList != null) {
                        for (Instruction dependency : instructionList) {
                            result2.add(Pair.create((Object)dependency, (Object)descriptor2));
                        }
                    }
                }
                super.visitElement(element);
            }
        });
        return result2;
    }

    @Nullable
    private static PsiElement findDependencyScope(@Nullable PsiElement element) {
        return PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> !(element1.getParent() instanceof GrExpression) || element1 instanceof GrBinaryExpression || element1 instanceof GrInstanceOfExpression || PsiUtil.isExpressionStatement(element1));
    }

    private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult) {
        this.myVarTypes.accumulateAndGet(dfaResult, InferenceCache::addDfaResult);
    }

    @NotNull
    private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> oldTypes, @NotNull List<TypeDfaState> dfaResult) {
        ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
        for (int i = 0; i < dfaResult.size(); ++i) {
            newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
        }
        return newTypes;
    }
}

