/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;

class TypeDfaState {
    private final Map<VariableDescriptor, DFAType> myVarTypes;

    TypeDfaState() {
        this.myVarTypes = ContainerUtil.newHashMap();
    }

    TypeDfaState(TypeDfaState another) {
        this.myVarTypes = ContainerUtil.newHashMap(another.myVarTypes);
    }

    Map<VariableDescriptor, DFAType> getVarTypes() {
        return this.myVarTypes;
    }

    TypeDfaState mergeWith(TypeDfaState another) {
        if (another.myVarTypes.isEmpty()) {
            return this;
        }
        TypeDfaState state = new TypeDfaState(this);
        state.myVarTypes.putAll(another.myVarTypes);
        return state;
    }

    void joinState(TypeDfaState another, PsiManager manager) {
        for (Map.Entry<VariableDescriptor, DFAType> entry : another.myVarTypes.entrySet()) {
            VariableDescriptor descriptor2 = entry.getKey();
            DFAType t1 = entry.getValue();
            if (!this.myVarTypes.containsKey(descriptor2)) continue;
            DFAType t2 = this.myVarTypes.get(descriptor2);
            if (t1 != null && t2 != null) {
                this.myVarTypes.put(descriptor2, DFAType.create(t1, t2, manager));
                continue;
            }
            this.myVarTypes.put(descriptor2, null);
        }
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes);
    }

    @Nullable
    DFAType getVariableType(VariableDescriptor descriptor2) {
        return this.myVarTypes.get(descriptor2);
    }

    @Contract(value="_ -> new")
    @NotNull
    DFAType getOrCreateVariableType(VariableDescriptor descriptor2) {
        DFAType result2 = this.getVariableType(descriptor2);
        return result2 == null ? DFAType.create(null) : result2.copy();
    }

    Map<VariableDescriptor, PsiType> getBindings() {
        HashMap map2 = ContainerUtil.newHashMap();
        for (Map.Entry<VariableDescriptor, DFAType> entry : this.myVarTypes.entrySet()) {
            DFAType value = entry.getValue();
            map2.put(entry.getKey(), value == null ? null : value.getResultType());
        }
        return map2;
    }

    void putType(VariableDescriptor descriptor2, @Nullable DFAType type2) {
        this.myVarTypes.put(descriptor2, type2);
    }

    public String toString() {
        return this.myVarTypes.toString();
    }

    public boolean containsVariable(@NotNull VariableDescriptor descriptor2) {
        return this.myVarTypes.containsKey(descriptor2);
    }

    public void removeBinding(VariableDescriptor descriptor2) {
        this.myVarTypes.remove(descriptor2);
    }
}

