/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.CurryKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrClosureType
extends GrLiteralClassType {
    private final List<GrSignature> mySignatures;
    private volatile PsiType[] myTypeArgs;
    private static boolean ourForbidClosureInference;

    private GrClosureType(@NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull List<GrSignature> signatures, boolean shouldInferTypeParameters) {
        super(languageLevel, scope, facade);
        this.mySignatures = signatures;
        if (!shouldInferTypeParameters) {
            this.myTypeArgs = PsiType.EMPTY_ARRAY;
        }
    }

    private GrClosureType(@NotNull LanguageLevel level, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull List<GrSignature> signatures, @Nullable PsiType[] typeArgs) {
        super(level, scope, facade);
        this.mySignatures = signatures;
        this.myTypeArgs = typeArgs;
    }

    public int getParameterCount() {
        PsiClass resolved = this.resolve();
        return resolved != null && resolved.getTypeParameters().length == 1 ? 1 : 0;
    }

    @NotNull
    public PsiType[] getParameters() {
        if (ourForbidClosureInference) {
            throw new IllegalStateException();
        }
        if (this.myTypeArgs == null) {
            this.myTypeArgs = this.inferParameters();
        }
        return this.myTypeArgs;
    }

    @NotNull
    public PsiType[] inferParameters() {
        PsiClass psiClass = this.resolve();
        if (psiClass != null && psiClass.getTypeParameters().length == 1) {
            PsiType type2 = GrClosureSignatureUtil.getReturnType(this.mySignatures);
            if (type2 == PsiType.NULL || type2 == null) {
                return new PsiType[]{null};
            }
            return new PsiType[]{TypesUtil.boxPrimitiveType(type2, this.getPsiManager(), this.getResolveScope(), true)};
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "groovy.lang.Closure";
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        if (this.myTypeArgs != null && this.myTypeArgs.length == 0) {
            return this;
        }
        return new GrClosureType(this.getLanguageLevel(), this.getResolveScope(), this.myFacade, this.mySignatures, false);
    }

    public boolean isValid() {
        return ContainerUtil.all(this.mySignatures, GrSignature::isValid);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureType) {
            return Comparing.equal(this.mySignatures, ((GrClosureType)((Object)obj)).mySignatures);
        }
        return super.equals(obj);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrClosureType(languageLevel, this.myScope, this.myFacade, this.mySignatures, this.myTypeArgs);
    }

    @NotNull
    public static GrClosureType create(@NotNull Iterable<? extends GroovyResolveResult> results, @NotNull GroovyPsiElement context) {
        ArrayList<GrSignature> signatures = new ArrayList<GrSignature>();
        for (GroovyResolveResult groovyResolveResult : results) {
            if (!(groovyResolveResult.getElement() instanceof PsiMethod)) continue;
            signatures.add(GrClosureSignatureUtil.createSignature((PsiMethod)groovyResolveResult.getElement(), groovyResolveResult.getSubstitutor()));
        }
        GlobalSearchScope resolveScope = context.getResolveScope();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
        return GrClosureType.create(signatures, resolveScope, javaPsiFacade, LanguageLevel.JDK_1_5, true);
    }

    public static GrClosureType create(@NotNull GrFunctionalExpression expression, boolean shouldInferTypeParameters) {
        GrSignature signature = GrClosureSignatureUtil.createSignature(expression);
        GlobalSearchScope resolveScope = expression.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        return GrClosureType.create(Collections.singletonList(signature), resolveScope, facade, LanguageLevel.JDK_1_5, shouldInferTypeParameters);
    }

    @NotNull
    public static GrClosureType create(@NotNull List<GrSignature> signatures, GlobalSearchScope scope, JavaPsiFacade facade, @NotNull LanguageLevel languageLevel, boolean shouldInferTypeParameters) {
        return new GrClosureType(languageLevel, scope, facade, signatures, shouldInferTypeParameters);
    }

    @Nullable
    public PsiType curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        List<GrSignature> curried = CurryKt.curry(this.mySignatures, args, position, context);
        if (curried.isEmpty()) {
            return null;
        }
        return new GrClosureType(this.myLanguageLevel, this.myScope, this.myFacade, curried, this.myTypeArgs);
    }

    @NotNull
    public List<GrSignature> getSignatures() {
        return this.mySignatures;
    }

    public String toString() {
        return "PsiType: Closure<*>";
    }

    public static void forbidClosureInference(@NotNull Runnable runnable) {
        ourForbidClosureInference = true;
        try {
            runnable.run();
        }
        finally {
            ourForbidClosureInference = false;
        }
    }
}

