/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrMapTypeFromNamedArgs
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, GrExpression> myStringEntries;
    @NotNull
    private final List<Couple<GrExpression>> myOtherEntries;
    private final VolatileNotNullLazyValue<List<Couple<PsiType>>> myTypesOfOtherEntries = new VolatileNotNullLazyValue<List<Couple<PsiType>>>(){

        @NotNull
        protected List<Couple<PsiType>> compute() {
            return ContainerUtil.map((Collection)GrMapTypeFromNamedArgs.this.myOtherEntries, pair -> Couple.of((Object)GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)pair.first), (Object)GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)pair.second)));
        }
    };
    private final VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>> myTypesOfStringEntries = new VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>>(){

        @NotNull
        protected LinkedHashMap<String, PsiType> compute() {
            LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
            for (Map.Entry entry : GrMapTypeFromNamedArgs.this.myStringEntries.entrySet()) {
                result2.put(entry.getKey(), GrMapTypeFromNamedArgs.this.inferTypePreventingRecursion((GrExpression)entry.getValue()));
            }
            return result2;
        }
    };

    public GrMapTypeFromNamedArgs(@NotNull PsiElement context, @NotNull GrNamedArgument[] namedArgs) {
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(@NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull GrNamedArgument[] namedArgs) {
        super(facade, scope);
        this.myStringEntries = ContainerUtil.newLinkedHashMap();
        this.myOtherEntries = ContainerUtil.newArrayList();
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            GrExpression labelExpression = label.getExpression();
            if (labelExpression == null) continue;
            this.myOtherEntries.add((Couple<GrExpression>)Couple.of((Object)labelExpression, (Object)expression));
        }
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? this.inferTypePreventingRecursion(expression) : null;
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        return this.myStringEntries.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet result2 = ContainerUtil.newHashSet();
        if (!this.myStringEntries.isEmpty()) {
            result2.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<GrExpression> entry : this.myOtherEntries) {
            result2.add(this.inferTypePreventingRecursion((GrExpression)entry.first));
        }
        result2.remove(null);
        return result2.toArray(GrMapTypeFromNamedArgs.createArray((int)result2.size()));
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet result2 = ContainerUtil.newHashSet();
        for (GrExpression grExpression : this.myStringEntries.values()) {
            result2.add(this.inferTypePreventingRecursion(grExpression));
        }
        for (Couple couple : this.myOtherEntries) {
            result2.add(this.inferTypePreventingRecursion((GrExpression)couple.second));
        }
        result2.remove(null);
        return result2.toArray(GrMapTypeFromNamedArgs.createArray((int)result2.size()));
    }

    @Nullable
    private PsiType inferTypePreventingRecursion(GrExpression expression) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> TypesUtil.boxPrimitiveType(expression.getType(), expression.getManager(), this.myScope));
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        return (List)this.myTypesOfOtherEntries.getValue();
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        return (LinkedHashMap)this.myTypesOfStringEntries.getValue();
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (!((GrExpression)couple.first).isValid()) {
                return false;
            }
            if (((GrExpression)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeFromNamedArgs args = (GrMapTypeFromNamedArgs)((Object)o);
        if (!this.myStringEntries.equals(args.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(args.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }
}

